% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{aggregateCRT}
\alias{aggregateCRT}
\title{Aggregate data across records with duplicated locations}
\usage{
aggregateCRT(trial, auxiliaries = NULL)
}
\arguments{
\item{trial}{An object of class \code{"CRTsp"} containing locations (x,y) and variables to be summed}

\item{auxiliaries}{vector of names of auxiliary variables to be summed across each location}
}
\value{
A list of class \code{"CRTsp"}
}
\description{
\code{aggregateCRT} aggregates data from a \code{"CRTsp"} object or trial data frame containing multiple records with the same location,
and outputs a list of class \code{"CRTsp"} containing single values for each location, for both the coordinates and the auxiliary variables.
}
\details{
Variables that in the trial dataframe that are not included in \code{auxiliaries} are retained in the output
algorithm \code{"CRTsp"} object, with the value corresponding to that of the first record for the location
in the input data frame
}
\examples{
{
trial <- readdata('example_site.csv')
trial$base_denom <- 1
aggregated <- aggregateCRT(trial, auxiliaries = c("RDT_test_result","base_denom"))
}
}
