% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_ite_aipw.R
\name{estimate_ite_aipw}
\alias{estimate_ite_aipw}
\title{Estimate the Individual Treatment Effect (ITE) using Augmented Inverse
Probability Weighting (AIPW)}
\usage{
estimate_ite_aipw(
  y,
  z,
  X,
  ps_method = "SL.xgboost",
  oreg_method = "SL.xgboost"
)
}
\arguments{
\item{y}{An observed response vector.}

\item{z}{A treatment vector.}

\item{X}{A features matrix.}

\item{ps_method}{A estimation model for the propensity score.}

\item{oreg_method}{A estimation model for the outcome regressions.}
}
\value{
A list of ITE estimates.
}
\description{
Estimates the Individual Treatment Effect using Augmented Inverse Probability
Weighting given a response vector, a treatment vector, a features matrix,
an estimation model for the propensity score and estimation model for the
outcome regressions.
}
\keyword{internal}
