% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.CRABSsets.R
\name{print.CRABSsets}
\alias{print.CRABSsets}
\title{print.CRABSsets}
\usage{
\method{print}{CRABSsets}(x, ...)
}
\arguments{
\item{x}{a list of (congruent) CRABS sets}

\item{...}{additional parameters}
}
\value{
nothing
}
\description{
print.CRABSsets
}
\examples{
data(primates_ebd_log)

posterior <- read.RevBayes(primates_ebd_log, max_t = 65, n_samples = 10)

samples <- sample.congruence.class.posterior(posterior, 
                                             num.samples = 5,
                                             rate.type = "extinction",
                                             rate0.median = 0.1,
                                             model = "MRF",
                                             max.rate = 1.0)
                                             
print(samples)
}
