% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_covid.R
\name{read_covid}
\alias{read_covid}
\title{Read PNAD COVID19 microdata}
\usage{
read_covid(microdata, vars = NULL)
}
\arguments{
\item{microdata}{A comma-separated values file containing microdata from PNAD COVID19 survey, available on official website: (select a microdata file) - \url{https://ftp.ibge.gov.br/Trabalho_e_Rendimento/Pesquisa_Nacional_por_Amostra_de_Domicilios_PNAD_COVID19/Microdados/Dados/}.}

\item{vars}{Vector of variable names to be kept for analysis. Default is to keep all variables.}
}
\value{
A tibble with selected variables of the microdata, including the necessary survey design ones.
}
\description{
This function reads PNAD COVID19 microdata.
}
\note{
For more information, visit the survey official website <\url{https://www.ibge.gov.br/estatisticas/investigacoes-experimentais/estatisticas-experimentais/27946-divulgacao-semanal-pnadcovid1?t=o-que-e}> and consult the other functions of this package, described below.
}
\examples{
data_path <- covid_example(path="exampledata.csv")
covid.df <- read_covid(microdata=data_path, vars="C002")
}
\seealso{
\link[COVIDIBGE]{get_covid} for downloading, labelling, deflating and creating survey design object for PNAD COVID19 microdata.\cr \link[COVIDIBGE]{covid_labeller} for labelling categorical variables from PNAD COVID19 microdata.\cr \link[COVIDIBGE]{covid_deflator} for adding deflator variables to PNAD COVID19 microdata.\cr \link[COVIDIBGE]{covid_design} for creating PNAD COVID19 survey design object.\cr \link[COVIDIBGE]{covid_example} for getting the path of the PNAD COVID19 example files.
}
