% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/COMBIA.R
\name{readOtherValues}
\alias{readOtherValues}
\title{Read data from other than MacSynergy and FMCA format and clean for outliers.}
\usage{
readOtherValues(file, sheet, wellRangesExcel, platetype, minThersholdForCVCal,
  minThersholdForCV, survivalFunc, xConcentration, yConcentration)
}
\arguments{
\item{file}{Name of file to be read.}

\item{sheet}{Sheet number of a workbook.}

\item{wellRangesExcel}{well ranges in excel format.}

\item{platetype}{384.}

\item{minThersholdForCVCal}{CV threshold for data outliers.}

\item{minThersholdForCV}{Threshold of survival values not used for CV calculations.}

\item{survivalFunc}{A function to calculate survival values,
by default survival is calculated as, Survival= tereated- background/untreated control-background.}

\item{xConcentration}{Concentrations of drug at x-axis of data.}

\item{yConcentration}{Concentrations of drugs at y-axis of data.}
}
\value{
Matrix of outlier removed replicates.
}
\description{
Read data from other than MacSynergy and FMCA format and clean for outliers.
}
\examples{
fl <- system.file("/raw/FluoOptima_384_2014-03-28test.xls", package="COMBIA")
wls <- list(  c(  "K1:K8", "L1:L8","A1:J8",     "K9:K16", "L9:L16","A9:J16",
                  "W1:W8", "X1:X8","M1:V8",     "W9:W16", "X9:X16","M9:V16")
                  )
sh <- 1
pltype <- "384"
minThersholdForCVCal <- 0.1
minThersholdForCV<- 0.3
survivalFunc <- function (x,y,z) {(x-z)/(y-z)}
xConc <- c(0.00,  0.20,  0.39,  0.78,  1.56,  3.12,  6.25, 12.50, 25.00, 50.00)
yConc <- c(128,  64,  32,  16,   8,   4,   2,   0)
rslt <- readOtherValues(fl, sh, wls, pltype, minThersholdForCVCal,
                minThersholdForCV, survivalFunc, xConc, yConc )
}
\author{
Muhammad kashif
}

