% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coinToolIn.R
\name{import_coin_tool}
\alias{import_coin_tool}
\title{Import data directly from COIN Tool}
\usage{
import_coin_tool(fname, makecodes = FALSE, oldtool = FALSE, out2 = "list")
}
\arguments{
\item{fname}{The file name and path to read, e.g. \code{"C:/Documents/COINToolFile.xlsx"}.}

\item{makecodes}{Logical: if \code{TRUE}, will generate short indicator codes based on indicator names,
otherwise if \code{FALSE}, will use COIN Tool indicator codes \code{"Ind.01"}, etc. Currently only does this
for indicators, not aggregation groups.}

\item{oldtool}{Logical: if \code{TRUE}, compatible with old COIN Tool (pre-release, early 2019 or earlier).
There are some minor differences on where the elements are found.}

\item{out2}{Either \code{"list"} (default) to output a list with \code{iData} and \code{iMeta} entries (for input into \code{\link[=new_coin]{new_coin()}}),
else \code{"coin"} to output a coin.}
}
\value{
Either a list or a coin, depending on \code{out2}
}
\description{
The \href{https://knowledge4policy.ec.europa.eu/composite-indicators/coin-tool_en}{COIN Tool} is an Excel-based tool
for building composite indicators. This function provides a direct interface for reading a COIN Tool input deck and
converting it to COINr. You need to provide a COIN Tool file, with the "Database" sheet properly compiled.
}
\details{
This function replaces the now-defunct \code{COINToolIn()} from COINr < v1.0.
}
\examples{
\dontrun{
## This example downloads a COIN Tool spreadsheet containing example data,
## saves it to a temporary directory, unzips, and reads into R. Finally it
## assembles it into a COIN.

# Make temp zip filename in temporary directory
tmpz <- tempfile(fileext = ".zip")
# Download an example COIN Tool file to temporary directory
# NOTE: the download.file() command may need its "method" option set to a
# specific value depending on the platform you run this on. You can also
# choose to download/unzip this file manually.
download.file("https://knowledge4policy.ec.europa.eu/sites/default/
files/coin_tool_v1_lite_exampledata.zip", tmpz)
# Unzip
CTpath <- unzip(tmpz, exdir = tempdir())
# Read COIN Tool into R
l <- import_coin_tool(CTpath, makecodes = TRUE) }

}
