% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coin_resultstable.R
\name{getResults}
\alias{getResults}
\title{Results summary tables}
\usage{
getResults(
  COIN,
  tab_type = "Summ",
  use = "scores",
  order_by = NULL,
  nround = 2,
  use_group = NULL,
  out2 = "df"
)
}
\arguments{
\item{COIN}{The COIN object, or a data frame of indicator data}

\item{tab_type}{The type of table to generate. Either \code{"Summ"} (a single indicator plus rank), \code{"Aggs"} (all aggregated
scores/ranks above indicator level), or \code{"Full"} (all scores/ranks plus all group, denominator columns).}

\item{use}{Either \code{"scores"} (default), \code{"ranks"}, or \code{"groupranks"}. For the latter, \code{use_group} must be specified.}

\item{order_by}{A code of the indicator or aggregate to sort the table by. If not specified, defaults to the highest
aggregate level, i.e. the index in most cases. If \code{use_group} is specified, rows will also be sorted by the specified group.}

\item{nround}{The number of decimal places to round numerical values to. Defaults to 2.}

\item{use_group}{An optional grouping variable. If specified, the results table includes this group column,
and if \code{use = "groupranks"}, ranks will be returned with respect to the groups in this column.}

\item{out2}{If \code{"df"}, outputs a data frame (tibble). Else if \code{"COIN"} attaches to \code{.$Results} in an updated COIN.}
}
\value{
If \code{out2 = "df"}, the results table is returned as a data frame. If \code{out2 = "COIN"}, this function returns an updated
COIN with the results table attached to \code{.$Results}.
}
\description{
Generates fast results tables, either attached to the COIN or as a data frame.
}
\details{
Although results are available in a COIN in \code{.$Data}, the format makes it difficult to quickly present results. This function
generates results tables that are suitable for immediate presentation, i.e. sorted by index or other indicators, and only including
relevant columns. Scores are also rounded by default, and there is the option to present scores or ranks.
}
\examples{
# build ASEM COIN up to aggregation
ASEM <- build_ASEM()
# results table of scores for index and aggregates (excluding indicator scores)
dfResults <- getResults(ASEM, tab_type = "Aggregates", out2 = "df")

}
\seealso{
\itemize{
\item \code{\link[=resultsDash]{resultsDash()}} Interactive results dashboard
\item \code{\link[=coin2Excel]{coin2Excel()}} Export results to Excel
}
}
