% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GRanges_to_underscored_pos.R
\name{GRanges_to_underscored_pos}
\alias{GRanges_to_underscored_pos}
\title{Convert GRanges object to underscord positions.}
\usage{
GRanges_to_underscored_pos(input_gr, minusOneToEnd = T)
}
\arguments{
\item{input_gr}{A GenomicRanges object}

\item{minusOneToEnd}{Minus one position to end of each Genomic Range?}
}
\description{
This function converts row or column names (or any character vector of the format) into a GenomicRanges object.
}
\examples{
load(system.file("extdata","nbl_result_matrix_sign_small.rda",package = "CNVScope")) 
col_gr<-underscored_pos_to_GRanges(colnames(nbl_result_matrix_sign_small))
GRanges_to_underscored_pos(col_gr)
}
\keyword{Genomic}
\keyword{Ranges}
\keyword{position}
