% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weibull_model.R
\name{train_weibull_model}
\alias{train_weibull_model}
\title{Training function for Weibull model}
\source{
\url{https://www.cnaim.io/docs/fault-analysis/}
}
\usage{
train_weibull_model(transformer_faults_data)
}
\arguments{
\item{transformer_faults_data}{Data frame. Contains past data on transformer faults, together with environmental factors.
Must contain the following fields:
utilisation_pct: Numeric or "Default",
placement: "Indoor", "Outdoor" or "Default",
altitude_m: Numeric or "Default",
distance_from_coast_km: Numeric or "Default",
corrosion_category_index: Numeric or "Default",
partial_discharge: "Low", "Medium", "High (Not Confirmed)", "High (Confirmed)" or "Default",
oil_acidity: Numeric or "Default",
temperature_reading: "Normal", "Moderately High", "Very High" or "Default",
observed_condition: "No deterioration", "Superficial/minor deterioration", "Slight Deterioration", "Some deterioration", "Substantial deterioration" or "Default"
age: Numeric}
}
\value{
Data frame. All shape and scale parameters needed for the function \code{\link{predict_weibull_model}}().
}
\description{
This function uses transformer fault statistics data to train a Weibull model: Based on the environmental
factors determining a transformer's expected lifetime, the set of all data points is first partitioned into five parts.
Then a multilinear estimate for the expected lifetime of a transformer is trained for each part separately, and the
corresponding Weibull shape and scale parameters for the five parts are estimated. The function returns the shape and scale
parameters needed for the function \code{\link{predict_weibull_model}}().
}
\examples{
train_weibull_model(transformer_faults_data = transformer_11kv_faults)

}
