% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chapgwas.R
\name{SEL.HAP}
\alias{SEL.HAP}
\title{SEL.HAP: Haplotype selection and extension along the genome}
\usage{
SEL.HAP(GEN, YFIX, KIN, nHap, p.threshold, PAR)
}
\arguments{
\item{GEN}{Genotype matrix with rows corresponding to markers and
columns corresponding to individuals. The first two columns give
chromosome (\code{chr}) and physical position (\code{pos}); the
remaining columns contain alleles for each individual (e.g.
\code{"A"}, \code{"C"}, \code{"G"}, \code{"T"}), one allele per
haplotype copy.}

\item{YFIX}{A matrix or data.frame with phenotype in the first column
and fixed-effect covariates (e.g. intercept, PCs) in the remaining
columns, one row per individual.}

\item{KIN}{A list of kinship matrices, each of dimension
\eqn{n \times n}, where \eqn{n} is the number of individuals.}

\item{nHap}{Initial haplotype window size (number of consecutive
markers).}

\item{p.threshold}{P-value threshold for haplotype extension.}

\item{PAR}{Optional variance component parameters passed to
\code{RANDOM()}. If \code{NULL}, they are estimated internally.}
}
\value{
A list of three matrices summarizing:
  \itemize{
    \item \strong{FINAL[[1]]}: initial haplotype segments
    \item \strong{FINAL[[2]]}: extended haplotype segments
    \item \strong{FINAL[[3]]}: final selected segments after extension
  }
}
\description{
Perform genome-wide haplotype selection and extension using the
CHAP-GWAS framework. The function scans along each chromosome,
builds local haplotype segments, and adaptively extends them based
on association evidence with the phenotype.
}
\examples{
## Minimal example with small simulated data (alleles encoded as A/C/G/T)
set.seed(1)

## Number of individuals and markers
n_ind  <- 200
n_mark <- 50

## Construct a simple GEN matrix:
## first two columns: chromosome and position
## remaining columns: alleles "A","C","G","T"
chr <- rep(1, n_mark)
pos <- seq_len(n_mark) * 100
alleles <- c("A", "C", "G", "T")
geno <- matrix(sample(alleles, n_mark * n_ind, replace = TRUE),
               nrow = n_mark, ncol = n_ind)
GEN <- cbind(chr, pos, geno)

## Phenotype + intercept as fixed effect
y <- rnorm(n_ind)
X <- cbind(1, rnorm(n_ind))  # intercept + one covariate
YFIX <- cbind(y, X)

## Simple kinship: identity matrix
KIN <- list(diag(n_ind))

## Run SEL.HAP with a small initial window and mild threshold
res <- SEL.HAP(GEN, YFIX, KIN,
               nHap = 2,
               p.threshold = 0.05,
               PAR = NULL)

## Inspect the structure of the result (three matrices)
str(res)

}
