% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_io.R
\name{post_wrapper}
\alias{post_wrapper}
\title{Wrap the post_data() Function}
\usage{
post_wrapper(
  database,
  end_user,
  end_user_password,
  position,
  event_date,
  pt_comments,
  ldap = FALSE
)
}
\arguments{
\item{database}{MongoDB database.}

\item{end_user}{CEDARS end user name.}

\item{end_user_password}{CEDARS end user password.}

\item{position}{Sentence position within the sequence of selected sentences for a given patient.}

\item{event_date}{Date of clinical event as determined by human reviewer.}

\item{pt_comments}{Patient-specific comments from the reviewer.}

\item{ldap}{Is LDAP authentication being used? If so, password will not be checked and access will be granted automatically.}
}
\value{
{
No return value, called to post data.
}
}
\description{
Posts results of human reviewer annotation to MongoDB. Uses DB credentials pre-loaded in the main environment. For use with Shiny or REST POST (latter yet to be implemented).
}
\examples{
\dontrun{
post_wrapper(database = 'TEST_PROJECT', end_user = 'John', end_user_password = 'db_password_1234',
position = NA, event_date = NA, pt_comments = 'This is a comment')
}
}
