% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dictionaries.R
\name{negex_upload}
\alias{negex_upload}
\title{Upload NegEx}
\usage{
negex_upload(
  uri_fun,
  user,
  password,
  host,
  port,
  database,
  selected_model_path = NA
)
}
\arguments{
\item{uri_fun}{Uniform resource identifier (URI) string generating function for MongoDB credentials.}

\item{user}{MongoDB user name.}

\item{password}{MongoDB user password.}

\item{host}{MongoDB host server.}

\item{port}{MongoDB port.}

\item{database}{MongoDB database name.}

\item{selected_model_path}{Path to NLP model file.}
}
\value{
{
Confirmation of upload.
}
}
\description{
Prepares and uploads NegEx negation lexicon. It is not absolutely required for CEDARS to function but in practice will improve search accuracy for most applications.
}
\examples{
\dontrun{
negex_upload(uri_fun = mongo_uri_standard, user = 'John', password = 'db_password_1234',
host = 'server1234', port = NA, database = 'TEST_PROJECT', NA)
}
}
