% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate.R
\name{validateCdm}
\alias{validateCdm}
\alias{validate_cdm}
\title{Validation report for a CDM}
\usage{
validateCdm(cdm)

validate_cdm(cdm)
}
\arguments{
\item{cdm}{A cdm reference object.}
}
\value{
Invisibly returns the cdm input
}
\description{
Print a short validation report for a cdm object. The validation includes
checking that column names are correct and that no tables are empty. A short
report is printed to the console. This function is meant for interactive use.
}
\details{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
}
\examples{
\dontrun{
con <- DBI::dbConnect(duckdb::duckdb(), eunomiaDir())
cdm <- cdmFromCon(con, cdmSchema = "main")
validateCdm(cdm)
DBI::dbDisconnect(con)
}
}
