% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_Hashes.R
\name{create_Hashes}
\alias{create_Hashes}
\title{Create Hashes}
\usage{
create_Hashes(pol, angle = 45, spacing = 1, width = 1)
}
\arguments{
\item{pol}{single polygon inside which hashed lines will be created.
May be created using \code{\link{create_Polys}} or by subsetting an 
object obtained using one of the \code{load_} functions.}

\item{angle}{numeric, angle of the hashed lines in degrees (0-360), 
noting that the function might struggle with angles 0, 180, -180 or 360.}

\item{spacing}{numeric, spacing between hashed lines.}

\item{width}{numeric, width of hashed lines.}
}
\value{
Spatial object in your environment, to be added to your plot.
}
\description{
Create hashed lines to fill a polygon.
}
\examples{

# For more examples, see:
# https://github.com/ccamlr/CCAMLRGIS#25-create-hashes

#Create some polygons
MyPolys=create_Polys(Input=PolyData)
#Create hashes for each polygon
H1=create_Hashes(pol=MyPolys[1,],angle=45,spacing=1,width=1)
H2=create_Hashes(pol=MyPolys[2,],angle=90,spacing=2,width=2)
H3=create_Hashes(pol=MyPolys[3,],angle=0,spacing=3,width=3)

plot(st_geometry(MyPolys),col='cyan')
plot(st_geometry(H1),col='red',add=TRUE)
plot(st_geometry(H2),col='green',add=TRUE)
plot(st_geometry(H3),col='blue',add=TRUE)

}
\seealso{
\code{\link{create_Polys}}, \code{\link{add_Legend}}.
}
