/*
 * PreferencesDialog.java
 *
 * Created on October 3, 2005, 8:27 AM
 */
package org.neptuneinc.cadstat.prefs;

import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ChangeListener;

/**
 *
 * @author  Pasha Minallah
 */
public class PreferencesDialog extends javax.swing.JDialog implements ActionListener, ChangeListener
{
  public static final Float MAGNIFICATION_FACTOR = 4.0F;
  private PreferencesManager prefsManager;
  private boolean settingsChanged;

  /** Creates new form PreferencesDialog */
  public PreferencesDialog()
  {
    super();
    initComponents();

    initCustom();
  }

  /** Perform custom initialization. */
  protected void initCustom()
  {
    dataPointColor.setModel(new DefaultComboBoxModel(DataPointColor.values()));
    plotChar.setModel(new DefaultComboBoxModel(PlotCharacter.values()));

    prefsManager = new PreferencesManager();
    this.importPreferences();

    dataPointColor.addActionListener(this);
    plotChar.addActionListener(this);
    magPlotTitle.addChangeListener(this);
    magAxis.addChangeListener(this);
    magAxisLabel.addChangeListener(this);
    magDataPoint.addChangeListener(this);

    this.setSettingsChanged(false);

    updateValidity();

    this.getRootPane().setDefaultButton(saveButton);
  }

  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the Form Editor.
   */
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    tabbedPane = new javax.swing.JTabbedPane();
    plotPane = new javax.swing.JPanel();
    generalPane = new javax.swing.JPanel();
    jLabel1 = new javax.swing.JLabel();
    dataPointColor = new javax.swing.JComboBox();
    jLabel2 = new javax.swing.JLabel();
    plotChar = new javax.swing.JComboBox();
    magPane = new javax.swing.JPanel();
    jLabel4 = new javax.swing.JLabel();
    magPlotTitle = new javax.swing.JSlider();
    jLabel5 = new javax.swing.JLabel();
    magAxis = new javax.swing.JSlider();
    jLabel6 = new javax.swing.JLabel();
    magAxisLabel = new javax.swing.JSlider();
    jLabel7 = new javax.swing.JLabel();
    magDataPoint = new javax.swing.JSlider();
    buttonPane = new javax.swing.JPanel();
    cancelButton = new javax.swing.JButton();
    saveButton = new javax.swing.JButton();
    applyButton = new javax.swing.JButton();

    setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
    setTitle("Preferences");

    generalPane.setBorder(javax.swing.BorderFactory.createTitledBorder("General"));

    jLabel1.setLabelFor(dataPointColor);
    jLabel1.setText("Data Point Color:");

    jLabel2.setLabelFor(plotChar);
    jLabel2.setText("Plotting Character:");

    javax.swing.GroupLayout generalPaneLayout = new javax.swing.GroupLayout(generalPane);
    generalPane.setLayout(generalPaneLayout);
    generalPaneLayout.setHorizontalGroup(
      generalPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(generalPaneLayout.createSequentialGroup()
        .addContainerGap()
        .addGroup(generalPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
          .addComponent(jLabel2)
          .addComponent(jLabel1))
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addGroup(generalPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(plotChar, 0, 169, Short.MAX_VALUE)
          .addComponent(dataPointColor, 0, 169, Short.MAX_VALUE))
        .addContainerGap())
    );
    generalPaneLayout.setVerticalGroup(
      generalPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(generalPaneLayout.createSequentialGroup()
        .addGroup(generalPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(jLabel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
          .addComponent(dataPointColor, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addGroup(generalPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(jLabel2)
          .addComponent(plotChar, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
    );

    magPane.setBorder(javax.swing.BorderFactory.createTitledBorder("Magnification"));

    jLabel4.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
    jLabel4.setLabelFor(magPlotTitle);
    jLabel4.setText("Plot Title:");

    magPlotTitle.setMajorTickSpacing(2);
    magPlotTitle.setMaximum(12);
    magPlotTitle.setMinimum(2);
    magPlotTitle.setMinorTickSpacing(1);
    magPlotTitle.setPaintTrack(false);
    magPlotTitle.setSnapToTicks(true);
    magPlotTitle.setValue(4);

    jLabel5.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
    jLabel5.setLabelFor(magAxis);
    jLabel5.setText("Axis:");

    magAxis.setMajorTickSpacing(2);
    magAxis.setMaximum(12);
    magAxis.setMinimum(2);
    magAxis.setMinorTickSpacing(1);
    magAxis.setValue(4);

    jLabel6.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
    jLabel6.setLabelFor(magAxisLabel);
    jLabel6.setText("Axis Label:");

    magAxisLabel.setMajorTickSpacing(2);
    magAxisLabel.setMaximum(12);
    magAxisLabel.setMinimum(2);
    magAxisLabel.setMinorTickSpacing(1);
    magAxisLabel.setValue(4);

    jLabel7.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
    jLabel7.setLabelFor(magDataPoint);
    jLabel7.setText("Data Point:");

    magDataPoint.setMajorTickSpacing(2);
    magDataPoint.setMaximum(12);
    magDataPoint.setMinimum(2);
    magDataPoint.setMinorTickSpacing(1);
    magDataPoint.setValue(4);

    javax.swing.GroupLayout magPaneLayout = new javax.swing.GroupLayout(magPane);
    magPane.setLayout(magPaneLayout);
    magPaneLayout.setHorizontalGroup(
      magPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(magPaneLayout.createSequentialGroup()
        .addContainerGap()
        .addGroup(magPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
          .addComponent(jLabel6)
          .addComponent(jLabel7)
          .addComponent(jLabel5)
          .addComponent(jLabel4))
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addGroup(magPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(magAxis, javax.swing.GroupLayout.DEFAULT_SIZE, 238, Short.MAX_VALUE)
          .addComponent(magPlotTitle, javax.swing.GroupLayout.DEFAULT_SIZE, 238, Short.MAX_VALUE)
          .addComponent(magAxisLabel, javax.swing.GroupLayout.DEFAULT_SIZE, 238, Short.MAX_VALUE)
          .addComponent(magDataPoint, javax.swing.GroupLayout.DEFAULT_SIZE, 238, Short.MAX_VALUE))
        .addContainerGap())
    );
    magPaneLayout.setVerticalGroup(
      magPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(magPaneLayout.createSequentialGroup()
        .addContainerGap()
        .addGroup(magPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
          .addComponent(jLabel4)
          .addComponent(magPlotTitle, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        .addGroup(magPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
          .addComponent(jLabel5)
          .addComponent(magAxis, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addGroup(magPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
          .addComponent(jLabel6)
          .addComponent(magAxisLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addGroup(magPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
          .addComponent(jLabel7)
          .addComponent(magDataPoint, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addGap(211, 211, 211))
    );

    javax.swing.GroupLayout plotPaneLayout = new javax.swing.GroupLayout(plotPane);
    plotPane.setLayout(plotPaneLayout);
    plotPaneLayout.setHorizontalGroup(
      plotPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(plotPaneLayout.createSequentialGroup()
        .addContainerGap()
        .addGroup(plotPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(magPane, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
          .addComponent(generalPane, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        .addContainerGap())
    );
    plotPaneLayout.setVerticalGroup(
      plotPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(plotPaneLayout.createSequentialGroup()
        .addContainerGap()
        .addComponent(generalPane, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(magPane, javax.swing.GroupLayout.PREFERRED_SIZE, 259, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addContainerGap(13, Short.MAX_VALUE))
    );

    tabbedPane.addTab("Plot", plotPane);

    cancelButton.setText("Cancel");
    cancelButton.setMargin(new java.awt.Insets(0, 10, 0, 10));
    cancelButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        cancelButtonActionPerformed(evt);
      }
    });

    saveButton.setText("Save");
    saveButton.setMargin(new java.awt.Insets(0, 10, 0, 10));
    saveButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        saveButtonActionPerformed(evt);
      }
    });

    applyButton.setText("Apply");
    applyButton.setMargin(new java.awt.Insets(0, 10, 0, 10));
    applyButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        applyButtonActionPerformed(evt);
      }
    });

    javax.swing.GroupLayout buttonPaneLayout = new javax.swing.GroupLayout(buttonPane);
    buttonPane.setLayout(buttonPaneLayout);
    buttonPaneLayout.setHorizontalGroup(
      buttonPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(buttonPaneLayout.createSequentialGroup()
        .addGap(71, 71, 71)
        .addComponent(cancelButton, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
        .addComponent(saveButton, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
        .addComponent(applyButton, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        .addGap(73, 73, 73))
    );
    buttonPaneLayout.setVerticalGroup(
      buttonPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(buttonPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
        .addComponent(saveButton)
        .addComponent(applyButton)
        .addComponent(cancelButton))
    );

    javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
    getContentPane().setLayout(layout);
    layout.setHorizontalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addContainerGap()
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(buttonPane, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
          .addComponent(tabbedPane, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 416, Short.MAX_VALUE))
        .addContainerGap())
    );
    layout.setVerticalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addContainerGap()
        .addComponent(tabbedPane, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(buttonPane, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
    );

    pack();
  }// </editor-fold>//GEN-END:initComponents

  private void importPreferences()
  {
    try
    {
      prefsManager.importPreferences();
    }
    catch (Exception ex)
    {
      Logger.getLogger(PreferencesDialog.class.getName()).log(Level.INFO, null, ex);
    }

    dataPointColor.setSelectedItem(prefsManager.getCadstatPreferences().getDataPointColor());
    plotChar.setSelectedItem(prefsManager.getCadstatPreferences().getPlotCharacter());
    magPlotTitle.setValue(Math.round(prefsManager.getCadstatPreferences().getPlotTitleMagnification() * MAGNIFICATION_FACTOR));
    magAxis.setValue(Math.round(prefsManager.getCadstatPreferences().getAxisMagnification() * MAGNIFICATION_FACTOR));
    magAxisLabel.setValue(Math.round(prefsManager.getCadstatPreferences().getAxisLabelMagnification() * MAGNIFICATION_FACTOR));
    magDataPoint.setValue(Math.round(prefsManager.getCadstatPreferences().getDataPointMagnification() * MAGNIFICATION_FACTOR));
  }

  private void exportPreferences()
  {
    prefsManager.getCadstatPreferences().setDataPointColor((DataPointColor) dataPointColor.getSelectedItem());
    prefsManager.getCadstatPreferences().setPlotCharacter((PlotCharacter) plotChar.getSelectedItem());
    prefsManager.getCadstatPreferences().setPlotTitleMagnification(magPlotTitle.getValue() / MAGNIFICATION_FACTOR);
    prefsManager.getCadstatPreferences().setAxisMagnification(magAxis.getValue() / MAGNIFICATION_FACTOR);
    prefsManager.getCadstatPreferences().setAxisLabelMagnification(magAxisLabel.getValue() / MAGNIFICATION_FACTOR);
    prefsManager.getCadstatPreferences().setDataPointMagnification(magDataPoint.getValue() / MAGNIFICATION_FACTOR);

    try
    {
      prefsManager.exportPreferences();
    }
    catch (FileNotFoundException ex)
    {
      Logger.getLogger(PreferencesDialog.class.getName()).log(Level.SEVERE, null, ex);
    }
    catch (IOException ex)
    {
      Logger.getLogger(PreferencesDialog.class.getName()).log(Level.SEVERE, null, ex);
    }
    catch (BackingStoreException ex)
    {
      Logger.getLogger(PreferencesDialog.class.getName()).log(Level.SEVERE, null, ex);
    }
  }

  private void processSettingChange()
  {
    this.setSettingsChanged(true);

    updateValidity();
  }

  @Override
  public void actionPerformed(java.awt.event.ActionEvent actionEvent)
  {
    processSettingChange();
  }

  @Override
  public void stateChanged(javax.swing.event.ChangeEvent changeEvent)
  {
    processSettingChange();
  }

  private void saveButtonActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_saveButtonActionPerformed
  {//GEN-HEADEREND:event_saveButtonActionPerformed
    this.exportPreferences();

    this.dispose();
  }//GEN-LAST:event_saveButtonActionPerformed

  private void applyButtonActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_applyButtonActionPerformed
  {//GEN-HEADEREND:event_applyButtonActionPerformed
    this.exportPreferences();

    this.setSettingsChanged(false);

    updateValidity();
  }//GEN-LAST:event_applyButtonActionPerformed

  private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_cancelButtonActionPerformed
  {//GEN-HEADEREND:event_cancelButtonActionPerformed
    this.dispose();
  }//GEN-LAST:event_cancelButtonActionPerformed

  private void updateValidity()
  {
    applyButton.setEnabled(this.isSettingsChanged());
  }
  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JButton applyButton;
  private javax.swing.JPanel buttonPane;
  private javax.swing.JButton cancelButton;
  private javax.swing.JComboBox dataPointColor;
  private javax.swing.JPanel generalPane;
  private javax.swing.JLabel jLabel1;
  private javax.swing.JLabel jLabel2;
  private javax.swing.JLabel jLabel4;
  private javax.swing.JLabel jLabel5;
  private javax.swing.JLabel jLabel6;
  private javax.swing.JLabel jLabel7;
  private javax.swing.JSlider magAxis;
  private javax.swing.JSlider magAxisLabel;
  private javax.swing.JSlider magDataPoint;
  private javax.swing.JPanel magPane;
  private javax.swing.JSlider magPlotTitle;
  private javax.swing.JComboBox plotChar;
  private javax.swing.JPanel plotPane;
  private javax.swing.JButton saveButton;
  private javax.swing.JTabbedPane tabbedPane;
  // End of variables declaration//GEN-END:variables

  protected boolean isSettingsChanged()
  {
    return settingsChanged;
  }

  protected void setSettingsChanged(boolean settingsChanged)
  {
    this.settingsChanged = settingsChanged;
  }
}
