% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BuddleMain.R
\name{GetPrecision}
\alias{GetPrecision}
\title{Obtaining Accuracy.}
\usage{
GetPrecision(confusion.matrix)
}
\arguments{
\item{confusion.matrix}{a confusion matrix.}
}
\value{
An (r+1)-by-3 matrix when the input is an r-by-r confusion matrix.
}
\description{
Compute measures of accuracy such as precision, recall, and F1 from a given confusion matrix.
}
\examples{

data(iris)

Label = c("setosa", "versicolor", "virginica")

predicted.label = c("setosa", "setosa",    "virginica", "setosa", "versicolor", "versicolor")
true.label      = c("setosa", "virginica", "versicolor","setosa", "versicolor", "virginica")

confusion.matrix = MakeConfusionMatrix(predicted.label, true.label, Label)
precision = GetPrecision(confusion.matrix)

}
\seealso{
CheckNonNumeric(), FetchBuddle(), MakeConfusionMatrix(), OneHot2Label(), Split2TrainTest(), TrainBuddle()
}
