% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importance.R
\name{getImpXgboost}
\alias{getImpXgboost}
\title{Xgboost importance}
\usage{
getImpXgboost(x, y, nrounds = 5, verbose = 0, ...)
}
\arguments{
\item{x}{data frame of predictors including shadows.}

\item{y}{response vector.}

\item{nrounds}{Number of rounds; passed to the underlying \code{\link[xgboost]{xgboost}} call.}

\item{verbose}{Verbosity level of xgboost; either 0 (silent) or 1 (progress reports). Passed to the underlying \code{\link[xgboost]{xgboost}} call.}

\item{...}{other parameters passed to the underlying \code{\link[xgboost]{xgboost}} call.
Similarly as \code{nrounds} and \code{verbose}, they are relayed from \code{...} of \code{\link{Boruta}}.
For convenience, this function sets \code{nrounds} to 5 and verbose to 0, but this can be overridden.}
}
\description{
This function is intended to be given to a \code{getImp} argument of \code{\link{Boruta}} function to be called by the Boruta algorithm as an importance source.
}
\note{
Only dense matrix interface is supported; all predictions given to \code{\link{Boruta}} call have to be numeric (not integer).
Categorical features should be split into indicator attributes.
This functionality is inspired by the Python package BoostARoota by Chase DeHan.
I have some doubts whether boosting importance can be used for all relevant selection without hitting substantial false negative rates; please consider this functionality experimental.
}
\references{
\url{https://github.com/chasedehan/BoostARoota}
}
