% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{probit.trans}
\alias{probit.trans}
\title{Probit-transform the data and apply Abbott's correction}
\usage{
probit.trans(dataf, conf = 0.05)
}
\arguments{
\item{dataf}{a data frame of mortality data containing four mandatory
columns "strain", "dose", "total", "dead" (not necessarily in that order).}

\item{conf}{numerical. Threshold for the mortality in the controls above
which the correction should be applied (default=0.05)}
}
\value{
Returns a list. convrg: with correction values and convergence
(NULL if mortality in the controls is below conf.), tr.data: transformed
data
}
\description{
This function applies probit transformation to the data, after applying
Abbott's correction (see reference) when control groups (e.g. unexposed
susceptible strain) show non-negligible mortality.
}
\examples{
data(bioassay)
transd<-probit.trans(bioassay)
}
\references{
Abbott, WS (1925). A method of computing the effectiveness of
an insecticide. J. Econ. Entomol.;18:265‐267.
}
\author{
Pascal Milesi, Piyal Karunarathne, Pierrick Labbé
}
