% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bdapply_Function_hdf5}
\alias{bdapply_Function_hdf5}
\title{Apply function to different datasets inside a group}
\usage{
bdapply_Function_hdf5(
  filename,
  group,
  datasets,
  outgroup,
  func,
  b_group = NULL,
  b_datasets = NULL,
  force = FALSE
)
}
\arguments{
\item{filename, }{Character array, indicating the name of the file to create}

\item{group, }{Character array, indicating the input group where the data set to be imputed is.}

\item{datasets, }{Character array, indicating the input datasets to be used}

\item{outgroup, }{Character, array, indicating group where the data set will be saved after imputation if `outgroup` is NULL, output dataset is stored in the same input group.}

\item{func, }{Character array, function to be applyed : 
QR to apply bdQR() function to datasets
CrossProd to apply bdCrossprod() function to datasets
tCrossProd to apply bdtCrossprod() function to datasets
invChol to apply bdInvCholesky() function to datasets
blockmult to apply matrix multiplication, in that case, we need the datasets to be used defined
    in b_datasets variable, datasets and b_datasets must be of the same lenght, in that case, the operation is performed according to index, for example,
    if we have datasets = {"A1", "A2", "A3} and b_datasets = {"B1", "B2", "B3}, the functions performs : A1%*%B1, A2%*%B2 and A3%*%B3 
CrossProd_double to  performs crossprod using two matrices, see blockmult 
tCrossProd_double to  performs transposed crossprod using two matrices, see blockmult 
solve to solve matrix equation system, see blockmult for parametrization}

\item{b_group, }{optional Character array indicating the input group where data are stored when we need a second dataset to operate, for example in functions like matrix multiplication}

\item{b_datasets, }{optional Character array indicating the input datasets to be used when we need a second dataset in functions like matrix multiplication}

\item{force, }{optional Boolean if true, previous results in same location inside hdf5 will be overwritten, by default force = false, data was not overwritten..}
}
\value{
Original hdf5 data file with results after apply function to different datasets
}
\description{
Apply function to different datasets inside a group
}
