% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bdSVD_hdf5}
\alias{bdSVD_hdf5}
\title{Block SVD decomposition using an incremental algorithm.}
\usage{
bdSVD_hdf5(
  file,
  group = NULL,
  dataset = NULL,
  k = 2L,
  q = 1L,
  bcenter = TRUE,
  bscale = TRUE,
  rankthreshold = 0,
  threads = NULL
)
}
\arguments{
\item{file}{a real nxp matrix in hdf5 file}

\item{group}{group in hdf5 data file where dataset is located}

\item{dataset}{matrix dataset with data to perform SVD}

\item{k}{number of local SVDs to concatenate at each level}

\item{q}{number of levels}

\item{bcenter}{(optional, defalut = TRUE) . If center is TRUE then centering is done by subtracting the column means (omitting NAs) of x from their corresponding columns, and if center is FALSE, no centering is done.}

\item{bscale}{(optional, defalut = TRUE) .  If scale is TRUE then scaling is done by dividing the (centered) columns of x by their standard deviations if center is TRUE, and the root mean square otherwise. If scale is FALSE, no scaling is done.}

\item{rankthreshold}{double, threshold used to determine the range of the array. The matrix rank is equal to the number of
singular values different from the threshold. By default, threshold = 0 is used to get the matrix rank , but it can be
changed to an approximation of 0.}

\item{threads}{(optional) only used in some operations inside function. If threads is null then threads =  maximum number of threads available - 1.}
}
\value{
a list of three components with the singular values and left and right singular vectors of the matrix

A List with : 
\itemize{
  \item{"u"}{ eigenvectors of AA^t, mxn and column orthogonal matrix }
  \item{"v"}{ eigenvectors of A^tA, nxn orthogonal matrix }
  \item{"v"}{ singular values, nxn diagonal matrix (non-negative real values) }
}
}
\description{
Block SVD decomposition for hdf5 files using an incremental algorithm.
}
\details{
Singular values and left singular vectors of a real nxp matrix
}
