% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bibit.R
\name{bibit}
\alias{bibit}
\title{The BiBit Algorithm}
\usage{
bibit(matrix = NULL, minr = 2, minc = 2, arff_row_col = NULL,
  output_path = NULL)
}
\arguments{
\item{matrix}{The binary input matrix.}

\item{minr}{The minimum number of rows of the Biclusters.}

\item{minc}{The minimum number of columns of the Biclusters.}

\item{arff_row_col}{If you want to circumvent the internal R function to convert the matrix to \code{.arff} format, provide the pathname of this file here. Additionally, two \code{.csv} files should be provided containing 1 column of row and column names. These two files should not contain a header or quotes around the names, simply 1 column with the names.\cr 
(\emph{Example}: \code{arff_row_col=c("...\\\\data\\\\matrix.arff","...\\\\data\\\\rownames.csv","...\\\\data\\\\colnames.csv")})\cr
\emph{Note:} These files can be generated with the \code{make_arff_row_col} function.}

\item{output_path}{If as output, the original txt output of the Java code is desired, provide the outputh path here (without extension). In this case the \code{bibit} function will skip the transformation to a Biclust class object and simply return \code{NULL}.\cr 
(\emph{Example}: \code{output_path="...\\\\out\\\\bibitresult"})
\cr
(\emph{Description Output}: The following information about every bicluster generated will be printed in the output file: number of rows, number of columns, name of rows and name of columns.}
}
\value{
A Biclust S4 Class object.
}
\description{
A R-wrapper which directly calls the original Java code for the BiBit algorithm (\url{http://eps.upo.es/bigs/BiBit.html}) and transforms it to the output format of the \code{Biclust} R package.
}
\details{
This function uses the original Java code directly (with the intended input and output). Because the Java code was not refactored, the \code{rJava} package could not be used.
The \code{bibit} function does the following:
\enumerate{
\item Convert R matrix to a \code{.arff} output file.
\item Use the \code{.arff} file as input for the Java code which is called by \code{system()}.
\item The outputted \code{.txt} file from the Java BiBit algorithm is read in and transformed to a \code{Biclust} object.
}
Because of this, there is a chance of \emph{overhead} when applying the algorithm on large datasets. Make sure your machine has enough RAM available when applying to big data.
}
\examples{
\dontrun{
data <- matrix(sample(c(0,1),100*100,replace=TRUE,prob=c(0.9,0.1)),nrow=100,ncol=100)
data[1:10,1:10] <- 1 # BC1
data[11:20,11:20] <- 1 # BC2
data[21:30,21:30] <- 1 # BC3
data <- data[sample(1:nrow(data),nrow(data)),sample(1:ncol(data),ncol(data))]
result <- bibit(data,minr=5,minc=5)
result
}
}
\author{
Ewoud De Troyer
}
\references{
Domingo S. Rodriguez-Baena, Antonia J. Perez-Pulido and Jesus S. Aguilar-Ruiz (2011), "A biclustering algorithm for extracting bit-patterns from binary datasets", \emph{Bioinformatics}
}

