% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{probability_pathogenic}
\alias{probability_pathogenic}
\title{Calculate region or variant-level probability of pathogencity given prior probability on pathogenicity of region}
\usage{
probability_pathogenic(prior = 0.05, variant_level = FALSE, y, G,
  min_ac = 1, ...)
}
\arguments{
\item{prior}{Numeric value giving prior for probability of pathogenicity of region.}

\item{variant_level}{Logical value determining whether to return the probabilities of pathogenicity for the individual variants or for the region as a whole.}

\item{y}{Logical vector of case (\code{TRUE}) control (\code{FALSE}) status.}

\item{G}{Integer matrix of variant counts per individual, one column per individual and one row per variant.}

\item{min_ac}{Minimum allele count per individual to be considered to have a pathogenic combination of variants. '1' could correspond to a dominant inheritance hypothesis whereas '2' could correspond to a recessive inheritance hypothesis.}

\item{...}{Other arguments to pass to \code{\link{bevimed}}.}
}
\value{
Probabilities of pathogenicity.
}
\description{
Calculate region or variant-level probability of pathogencity given prior probability on pathogenicity of region
}

