% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplesize.R
\name{samplesize}
\alias{samplesize}
\title{Find minimum sample size with Beta distribution}
\usage{
samplesize(mu0, sd0, mu1.start, mu1.end = NULL, mu1.by = NULL, 
power.start, power.end = NULL, power.by = NULL, sig.level = 0.05, 
trials = 100, delta = 1, seed = 1, link.type = "logit", 
equal.precision = TRUE, sd1 = NULL)
}
\arguments{
\item{mu0}{mean for the control group}

\item{sd0}{standard deviation for the control group}

\item{mu1.start}{starting value of mean for the treatment group under the alternative mu1}

\item{mu1.end}{ending value of mean for the treatment group under the alternative mu1}

\item{mu1.by}{step length of mean for the treatment group under the alternative mu1}

\item{power.start}{starting value of target power}

\item{power.end}{ending value of target power}

\item{power.by}{step length of target power}

\item{sig.level}{significant level; default value is 0.05}

\item{trials}{number of trials; default value is 100}

\item{delta}{accuracy of the result; must be integer}

\item{seed}{seed used in the simulation}

\item{link.type}{type of link used in the beta regression. Default link is "logit". Other link options include: "logit", "probit", "cloglog", "log", "loglog", "wilcoxon", or you can use "all" for all types of link}

\item{equal.precision}{equal dispersion parameter assumption in simulation}

\item{sd1}{standard deviation for the treatment group. Only applicable when equal.precision = FALSE}
}
\value{
Return a samplesize object including basic settings (mean and standard deviation for the control group, 
significant level, number of trials and link types), and a matrix of estimated power with given mu1 and target power.
\item{minimum sample size: link type:}{minimum sample size for given given mu0, sd0, mu1, target power and type of link.}
\item{minimum power: link type:}{the minimum power greater than or equal to target power.}
\item{target power:}{target power.}
\item{mu1:}{mean for the treatment group under alternative.}
}
\description{
Find minimum sample sizes with Beta distribution and given mu0,sd0,mu1 and target powers.
}
\details{
The samplesize function allows you to control the number of trials in the simulation, 
the target power, delta, and the alternative means.
You can fix the alternative and vary power to match a desired sample size; 
Use default values for the number of trials for a quick view;
Use a larger number of trials (say 1000) and a smaller delta (say 1) to get better estimates.\cr
The plot function will return a series of plots equal to the number of mu1 used in the procedure.
Type of link used in the beta regression. You can choose one or more of the following: "logit", "probit", "cloglog", "cauchit", "log", "loglog", "all". 
Y-axis denotes minimum sample size and X-axis denotes minimum power.\cr
}
\examples{
SSmat <- samplesize(mu0=0.56, sd0=0.255, mu1.start = 0.75, 
power.start =  0.8, power.end = 0.9, power.by = 0.1, 
trials = 25, link.type = c("log","wilcoxon"))
## show the results
SSmat
## add plot
plot(SSmat, link.type = c("log","wilcoxon"))
}
