// Generated by rstantools.  Do not edit by hand.

/*
    BeeGUTS is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    BeeGUTS is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with BeeGUTS.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_GUTS_SD_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'string', line 190, column 2 to column 34)",
                                                      " (in 'string', line 193, column 2 to column 55)",
                                                      " (in 'string', line 194, column 2 to column 55)",
                                                      " (in 'string', line 195, column 2 to column 55)",
                                                      " (in 'string', line 196, column 2 to column 33)",
                                                      " (in 'string', line 197, column 2 to column 31)",
                                                      " (in 'string', line 198, column 2 to column 30)",
                                                      " (in 'string', line 199, column 2 to column 50)",
                                                      " (in 'string', line 200, column 2 to column 62)",
                                                      " (in 'string', line 201, column 2 to column 25)",
                                                      " (in 'string', line 202, column 2 to column 25)",
                                                      " (in 'string', line 203, column 2 to column 25)",
                                                      " (in 'string', line 205, column 4 to column 58)",
                                                      " (in 'string', line 204, column 24 to line 206, column 3)",
                                                      " (in 'string', line 204, column 2 to line 206, column 3)",
                                                      " (in 'string', line 208, column 4 to column 45)",
                                                      " (in 'string', line 210, column 4 to column 194)",
                                                      " (in 'string', line 211, column 4 to column 79)",
                                                      " (in 'string', line 213, column 6 to column 98)",
                                                      " (in 'string', line 212, column 35 to line 214, column 5)",
                                                      " (in 'string', line 212, column 4 to line 214, column 5)",
                                                      " (in 'string', line 207, column 21 to line 215, column 3)",
                                                      " (in 'string', line 207, column 2 to line 215, column 3)",
                                                      " (in 'string', line 229, column 0 to column 33)",
                                                      " (in 'string', line 230, column 0 to column 33)",
                                                      " (in 'string', line 231, column 0 to column 38)",
                                                      " (in 'string', line 233, column 0 to column 28)",
                                                      " (in 'string', line 238, column 5 to column 69)",
                                                      " (in 'string', line 240, column 5 to column 70)",
                                                      " (in 'string', line 242, column 5 to column 78)",
                                                      " (in 'string', line 244, column 5 to column 139)",
                                                      " (in 'string', line 237, column 34 to line 245, column 4)",
                                                      " (in 'string', line 237, column 3 to line 245, column 4)",
                                                      " (in 'string', line 235, column 19 to line 246, column 1)",
                                                      " (in 'string', line 235, column 0 to line 246, column 1)",
                                                      " (in 'string', line 218, column 2 to column 38)",
                                                      " (in 'string', line 220, column 4 to column 135)",
                                                      " (in 'string', line 219, column 21 to line 222, column 3)",
                                                      " (in 'string', line 219, column 2 to line 222, column 3)",
                                                      " (in 'string', line 137, column 0 to column 24)",
                                                      " (in 'string', line 140, column 0 to column 20)",
                                                      " (in 'string', line 141, column 6 to column 12)",
                                                      " (in 'string', line 141, column 0 to column 31)",
                                                      " (in 'string', line 144, column 0 to column 24)",
                                                      " (in 'string', line 145, column 6 to column 16)",
                                                      " (in 'string', line 145, column 0 to column 28)",
                                                      " (in 'string', line 146, column 6 to column 16)",
                                                      " (in 'string', line 146, column 0 to column 29)",
                                                      " (in 'string', line 148, column 6 to column 12)",
                                                      " (in 'string', line 148, column 0 to column 34)",
                                                      " (in 'string', line 149, column 6 to column 12)",
                                                      " (in 'string', line 149, column 0 to column 34)",
                                                      " (in 'string', line 152, column 0 to column 25)",
                                                      " (in 'string', line 153, column 6 to column 17)",
                                                      " (in 'string', line 153, column 0 to column 29)",
                                                      " (in 'string', line 154, column 6 to column 17)",
                                                      " (in 'string', line 154, column 0 to column 29)",
                                                      " (in 'string', line 155, column 6 to column 17)",
                                                      " (in 'string', line 155, column 0 to column 31)",
                                                      " (in 'string', line 157, column 6 to column 12)",
                                                      " (in 'string', line 157, column 0 to column 34)",
                                                      " (in 'string', line 158, column 6 to column 12)",
                                                      " (in 'string', line 158, column 0 to column 34)",
                                                      " (in 'string', line 161, column 0 to column 18)",
                                                      " (in 'string', line 162, column 0 to column 16)",
                                                      " (in 'string', line 163, column 0 to column 18)",
                                                      " (in 'string', line 164, column 0 to column 16)",
                                                      " (in 'string', line 167, column 0 to column 12)",
                                                      " (in 'string', line 168, column 0 to column 12)",
                                                      " (in 'string', line 169, column 0 to column 13)",
                                                      " (in 'string', line 171, column 2 to column 20)",
                                                      " (in 'string', line 172, column 2 to column 18)",
                                                      " (in 'string', line 173, column 2 to column 20)",
                                                      " (in 'string', line 174, column 2 to column 18)",
                                                      " (in 'string', line 177, column 2 to column 28)",
                                                      " (in 'string', line 178, column 8 to column 19)",
                                                      " (in 'string', line 178, column 2 to column 37)",
                                                      " (in 'string', line 179, column 8 to column 18)",
                                                      " (in 'string', line 179, column 2 to column 35)",
                                                      " (in 'string', line 180, column 2 to column 12)",
                                                      " (in 'string', line 181, column 2 to column 12)",
                                                      " (in 'string', line 183, column 4 to column 70)",
                                                      " (in 'string', line 184, column 4 to column 56)",
                                                      " (in 'string', line 185, column 4 to column 68)",
                                                      " (in 'string', line 186, column 4 to column 54)",
                                                      " (in 'string', line 182, column 21 to line 187, column 3)",
                                                      " (in 'string', line 182, column 2 to line 187, column 3)",
                                                      " (in 'string', line 190, column 8 to column 21)",
                                                      " (in 'string', line 196, column 8 to column 17)",
                                                      " (in 'string', line 198, column 9 to column 20)",
                                                      " (in 'string', line 199, column 27 to column 38)",
                                                      " (in 'string', line 200, column 27 to column 38)",
                                                      " (in 'string', line 229, column 6 to column 17)",
                                                      " (in 'string', line 230, column 6 to column 17)",
                                                      " (in 'string', line 231, column 6 to column 17)",
                                                      " (in 'string', line 233, column 7 to column 18)",
                                                      " (in 'string', line 26, column 6 to column 14)",
                                                      " (in 'string', line 27, column 6 to column 12)",
                                                      " (in 'string', line 28, column 6 to column 19)",
                                                      " (in 'string', line 29, column 6 to column 16)",
                                                      " (in 'string', line 30, column 6 to column 17)",
                                                      " (in 'string', line 31, column 6 to column 19)",
                                                      " (in 'string', line 32, column 6 to column 20)",
                                                      " (in 'string', line 33, column 6 to column 15)",
                                                      " (in 'string', line 35, column 6 to column 31)",
                                                      " (in 'string', line 37, column 17 to column 27)",
                                                      " (in 'string', line 37, column 6 to column 27)",
                                                      " (in 'string', line 39, column 6 to column 28)",
                                                      " (in 'string', line 40, column 6 to column 20)",
                                                      " (in 'string', line 42, column 6 to column 25)",
                                                      " (in 'string', line 43, column 6 to column 36)",
                                                      " (in 'string', line 44, column 6 to column 36)",
                                                      " (in 'string', line 46, column 21 to column 40)",
                                                      " (in 'string', line 46, column 6 to column 40)",
                                                      " (in 'string', line 47, column 21 to column 33)",
                                                      " (in 'string', line 47, column 6 to column 33)",
                                                      " (in 'string', line 48, column 21 to column 31)",
                                                      " (in 'string', line 48, column 6 to column 31)",
                                                      " (in 'string', line 50, column 6 to column 15)",
                                                      " (in 'string', line 52, column 8 to column 20)",
                                                      " (in 'string', line 53, column 8 to column 17)",
                                                      " (in 'string', line 55, column 8 to column 47)",
                                                      " (in 'string', line 56, column 8 to column 34)",
                                                      " (in 'string', line 57, column 22 to column 40)",
                                                      " (in 'string', line 57, column 8 to column 40)",
                                                      " (in 'string', line 58, column 31 to column 43)",
                                                      " (in 'string', line 58, column 44 to column 64)",
                                                      " (in 'string', line 58, column 29 to column 66)",
                                                      " (in 'string', line 58, column 8 to column 66)",
                                                      " (in 'string', line 59, column 31 to column 43)",
                                                      " (in 'string', line 59, column 44 to column 64)",
                                                      " (in 'string', line 59, column 29 to column 66)",
                                                      " (in 'string', line 59, column 8 to column 66)",
                                                      " (in 'string', line 60, column 8 to column 24)",
                                                      " (in 'string', line 51, column 61 to line 61, column 7)",
                                                      " (in 'string', line 51, column 6 to line 61, column 7)",
                                                      " (in 'string', line 62, column 27 to column 74)",
                                                      " (in 'string', line 62, column 6 to column 74)",
                                                      " (in 'string', line 63, column 6 to column 23)",
                                                      " (in 'string', line 25, column 60 to line 64, column 2)",
                                                      " (in 'string', line 67, column 4 to column 23)",
                                                      " (in 'string', line 69, column 4 to column 90)",
                                                      " (in 'string', line 71, column 4 to column 26)",
                                                      " (in 'string', line 66, column 86 to line 72, column 1)",
                                                      " (in 'string', line 76, column 6 to line 77, column 58)",
                                                      " (in 'string', line 75, column 56 to line 78, column 1)",
                                                      " (in 'string', line 81, column 2 to column 53)",
                                                      " (in 'string', line 80, column 56 to line 82, column 1)",
                                                      " (in 'string', line 85, column 2 to column 52)",
                                                      " (in 'string', line 84, column 57 to line 86, column 1)",
                                                      " (in 'string', line 93, column 4 to column 23)",
                                                      " (in 'string', line 94, column 4 to column 23)",
                                                      " (in 'string', line 95, column 4 to column 23)",
                                                      " (in 'string', line 96, column 4 to column 23)",
                                                      " (in 'string', line 98, column 4 to column 25)",
                                                      " (in 'string', line 99, column 4 to column 20)",
                                                      " (in 'string', line 101, column 4 to column 23)",
                                                      " (in 'string', line 102, column 11 to column 16)",
                                                      " (in 'string', line 102, column 4 to column 50)",
                                                      " (in 'string', line 103, column 11 to column 16)",
                                                      " (in 'string', line 103, column 4 to column 57)",
                                                      " (in 'string', line 104, column 4 to column 54)",
                                                      " (in 'string', line 106, column 4 to column 155)",
                                                      " (in 'string', line 109, column 4 to column 46)",
                                                      " (in 'string', line 110, column 4 to column 18)",
                                                      " (in 'string', line 111, column 4 to column 26)",
                                                      " (in 'string', line 112, column 4 to column 37)",
                                                      " (in 'string', line 113, column 4 to column 18)",
                                                      " (in 'string', line 91, column 39 to line 114, column 3)",
                                                      " (in 'string', line 116, column 4 to column 21)",
                                                      " (in 'string', line 117, column 4 to column 25)",
                                                      " (in 'string', line 118, column 10 to column 18)",
                                                      " (in 'string', line 118, column 4 to line 123, column 30)",
                                                      " (in 'string', line 124, column 11 to column 19)",
                                                      " (in 'string', line 124, column 4 to column 28)",
                                                      " (in 'string', line 126, column 6 to column 37)",
                                                      " (in 'string', line 125, column 25 to line 127, column 5)",
                                                      " (in 'string', line 125, column 4 to line 127, column 5)",
                                                      " (in 'string', line 128, column 4 to column 15)",
                                                      " (in 'string', line 115, column 187 to line 129, column 3)"};
template <typename T0__, typename T1__>
int
find_interval_elem(const T0__& x, const T1__& sorted_arg__,
                   const int& start_ind, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__,
          stan::value_type_t<T1__>>;
  const auto& sorted = to_ref(sorted_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int res;
    res = std::numeric_limits<int>::min();
    
    int N;
    N = std::numeric_limits<int>::min();
    
    int max_iter;
    max_iter = std::numeric_limits<int>::min();
    
    local_scalar_t__ left;
    left = DUMMY_VAR__;
    
    local_scalar_t__ right;
    right = DUMMY_VAR__;
    
    int left_ind;
    left_ind = std::numeric_limits<int>::min();
    
    int right_ind;
    right_ind = std::numeric_limits<int>::min();
    
    int iter;
    iter = std::numeric_limits<int>::min();
    
    current_statement__ = 105;
    N = num_elements(sorted);
    current_statement__ = 107;
    if (logical_eq(N, 0)) {
      current_statement__ = 106;
      return 0;
    } 
    current_statement__ = 108;
    left_ind = start_ind;
    current_statement__ = 109;
    right_ind = N;
    current_statement__ = 110;
    max_iter = (100 * N);
    current_statement__ = 111;
    left = (sorted[(left_ind - 1)] - x);
    current_statement__ = 112;
    right = (sorted[(right_ind - 1)] - x);
    current_statement__ = 114;
    if (logical_lte(0, left)) {
      current_statement__ = 113;
      return (left_ind - 1);
    } 
    current_statement__ = 116;
    if (logical_eq(0, right)) {
      current_statement__ = 115;
      return (N - 1);
    } 
    current_statement__ = 118;
    if (logical_gt(0, right)) {
      current_statement__ = 117;
      return N;
    } 
    current_statement__ = 119;
    iter = 1;
    current_statement__ = 136;
    while ((primitive_value(logical_gt((right_ind - left_ind), 1)) &&
           primitive_value(logical_neq(iter, max_iter)))) {
      int mid_ind;
      mid_ind = std::numeric_limits<int>::min();
      
      local_scalar_t__ mid;
      mid = DUMMY_VAR__;
      
      current_statement__ = 122;
      mid_ind = ((left_ind + right_ind) / 2);
      current_statement__ = 123;
      mid = (sorted[(mid_ind - 1)] - x);
      current_statement__ = 125;
      if (logical_eq(mid, 0)) {
        current_statement__ = 124;
        return (mid_ind - 1);
      } 
      current_statement__ = 129;
      if (logical_lt((left * mid), 0)) {
        current_statement__ = 126;
        right = mid;
        current_statement__ = 127;
        right_ind = mid_ind;
      } 
      current_statement__ = 133;
      if (logical_lt((right * mid), 0)) {
        current_statement__ = 130;
        left = mid;
        current_statement__ = 131;
        left_ind = mid_ind;
      } 
      current_statement__ = 134;
      iter = (iter + 1);
    }
    current_statement__ = 138;
    if (logical_eq(iter, max_iter)) {
      current_statement__ = 137;
      if (pstream__) {
        stan_print(pstream__, "Maximum number of iterations reached.");
        stan_print(pstream__, "\n");
      }
    } 
    current_statement__ = 139;
    return left_ind;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct find_interval_elem_functor__ {
template <typename T0__, typename T1__>
int
operator()(const T0__& x, const T1__& sorted, const int& start_ind,
           std::ostream* pstream__)  const 
{
return find_interval_elem(x, sorted, start_ind, pstream__);
}
};
template <typename T0__, typename T1__, typename T2__, typename T3__,
typename T4__>
stan::promote_args_t<T0__, T1__, T2__, T3__,
T4__>
linearInterp(const T0__& t_x, const T1__& t_before, const T2__& t_after,
             const T3__& y_before, const T4__& y_after,
             std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__,
          T1__,
          T2__,
          T3__,
          T4__>;
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    local_scalar_t__ linInterp_hat;
    linInterp_hat = DUMMY_VAR__;
    
    current_statement__ = 142;
    linInterp_hat = (y_before +
                      (((t_x - t_before) * (y_after - y_before)) /
                        (t_after - t_before)));
    current_statement__ = 143;
    return linInterp_hat;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct linearInterp_functor__ {
template <typename T0__, typename T1__, typename T2__, typename T3__,
typename T4__>
stan::promote_args_t<T0__, T1__, T2__, T3__,
T4__>
operator()(const T0__& t_x, const T1__& t_before, const T2__& t_after,
           const T3__& y_before, const T4__& y_after, std::ostream* pstream__)  const 
{
return linearInterp(t_x, t_before, t_after, y_before, y_after, pstream__);
}
};
template <bool propto__, typename T0__, typename T1__, typename T2__>
stan::promote_args_t<T0__, T1__,
T2__>
loglogistic_2_lpdf(const T0__& y_hat, const T1__& mw, const T2__& beta,
                   std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__, T1__, T2__>;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 145;
    return (((stan::math::log(beta) - stan::math::log(mw)) +
              ((beta - 1) * (stan::math::log(y_hat) - stan::math::log(mw))))
             -
             (2 *
               log1p_exp(
                 (beta * (stan::math::log(y_hat) - stan::math::log(mw))))));
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct loglogistic_2_lpdf_functor__ {
template <bool propto__, typename T0__, typename T1__, typename T2__>
stan::promote_args_t<T0__, T1__,
T2__>
operator()(const T0__& y_hat, const T1__& mw, const T2__& beta,
           std::ostream* pstream__)  const 
{
return loglogistic_2_lpdf<propto__>(y_hat, mw, beta, pstream__);
}
};
template <typename T0__, typename T1__, typename T2__>
stan::promote_args_t<T0__, T1__,
T2__>
loglogistic_2_lcdf(const T0__& y_hat, const T1__& mw, const T2__& beta,
                   std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__, T1__, T2__>;
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 147;
    return -log1p_exp(
              (-beta * (stan::math::log(y_hat) - stan::math::log(mw))));
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct loglogistic_2_lcdf_functor__ {
template <typename T0__, typename T1__, typename T2__>
stan::promote_args_t<T0__, T1__,
T2__>
operator()(const T0__& y_hat, const T1__& mw, const T2__& beta,
           std::ostream* pstream__)  const 
{
return loglogistic_2_lcdf(y_hat, mw, beta, pstream__);
}
};
template <typename T0__, typename T1__, typename T2__>
stan::promote_args_t<T0__, T1__,
T2__>
loglogistic_2_lccdf(const T0__& y_hat, const T1__& mw, const T2__& beta,
                    std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__, T1__, T2__>;
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 149;
    return -log1p_exp(
              (beta * (stan::math::log(y_hat) - stan::math::log(mw))));
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct loglogistic_2_lccdf_functor__ {
template <typename T0__, typename T1__, typename T2__>
stan::promote_args_t<T0__, T1__,
T2__>
operator()(const T0__& y_hat, const T1__& mw, const T2__& beta,
           std::ostream* pstream__)  const 
{
return loglogistic_2_lccdf(y_hat, mw, beta, pstream__);
}
};
template <typename T0__, typename T1__, typename T2__, typename T3__>
Eigen::Matrix<stan::promote_args_t<T0__, stan::value_type_t<T1__>, T2__,
T3__>, -1, 1>
TKTD_varSD(const T0__& t, const T1__& y_arg__,
           const std::vector<T2__>& theta, const std::vector<T3__>& x_r,
           const std::vector<int>& x_i, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__,
          stan::value_type_t<T1__>,
          T2__,
          T3__>;
  const auto& y = to_ref(y_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    local_scalar_t__ kd;
    kd = DUMMY_VAR__;
    
    current_statement__ = 151;
    kd = theta[(1 - 1)];
    local_scalar_t__ zw;
    zw = DUMMY_VAR__;
    
    current_statement__ = 152;
    zw = theta[(2 - 1)];
    local_scalar_t__ bw;
    bw = DUMMY_VAR__;
    
    current_statement__ = 153;
    bw = theta[(3 - 1)];
    local_scalar_t__ hb;
    hb = DUMMY_VAR__;
    
    current_statement__ = 154;
    hb = theta[(4 - 1)];
    std::vector<local_scalar_t__> max_zw;
    max_zw = std::vector<local_scalar_t__>(2, DUMMY_VAR__);
    
    Eigen::Matrix<local_scalar_t__, -1, 1> dy_dt;
    dy_dt = Eigen::Matrix<local_scalar_t__, -1, 1>(2);
    stan::math::fill(dy_dt, DUMMY_VAR__);
    
    int Nconc;
    Nconc = std::numeric_limits<int>::min();
    
    current_statement__ = 157;
    Nconc = x_i[(1 - 1)];
    current_statement__ = 158;
    validate_non_negative_index("tconc", "Nconc", Nconc);
    Eigen::Matrix<local_scalar_t__, -1, 1> tconc;
    tconc = Eigen::Matrix<local_scalar_t__, -1, 1>(Nconc);
    stan::math::fill(tconc, DUMMY_VAR__);
    
    current_statement__ = 159;
    assign(tconc, nil_index_list(),
      to_vector(
        rvalue(x_r, cons_list(index_min_max(1, Nconc), nil_index_list()),
          "x_r")), "assigning variable tconc");
    current_statement__ = 160;
    validate_non_negative_index("conc", "Nconc", Nconc);
    Eigen::Matrix<local_scalar_t__, -1, 1> conc;
    conc = Eigen::Matrix<local_scalar_t__, -1, 1>(Nconc);
    stan::math::fill(conc, DUMMY_VAR__);
    
    current_statement__ = 161;
    assign(conc, nil_index_list(),
      to_vector(
        rvalue(x_r,
          cons_list(index_min_max((Nconc + 1), (2 * Nconc)),
            nil_index_list()), "x_r")), "assigning variable conc");
    int pulse_index;
    pulse_index = std::numeric_limits<int>::min();
    
    current_statement__ = 162;
    pulse_index = find_interval_elem(t, tconc, 1, pstream__);
    local_scalar_t__ conc_linInterp;
    conc_linInterp = DUMMY_VAR__;
    
    current_statement__ = 163;
    conc_linInterp = (logical_neq(pulse_index, 0) ?
                        linearInterp(t, tconc[(pulse_index - 1)],
                          tconc[((pulse_index + 1) - 1)],
                          conc[(pulse_index - 1)],
                          conc[((pulse_index + 1) - 1)], pstream__) :
                        conc[(1 - 1)]);
    current_statement__ = 164;
    assign(dy_dt, cons_list(index_uni(1), nil_index_list()),
      (kd * (conc_linInterp - y[(1 - 1)])), "assigning variable dy_dt");
    current_statement__ = 165;
    assign(max_zw, cons_list(index_uni(1), nil_index_list()), 0,
      "assigning variable max_zw");
    current_statement__ = 166;
    assign(max_zw, cons_list(index_uni(2), nil_index_list()),
      (y[(1 - 1)] - zw), "assigning variable max_zw");
    current_statement__ = 167;
    assign(dy_dt, cons_list(index_uni(2), nil_index_list()),
      ((bw * max(max_zw)) + hb), "assigning variable dy_dt");
    current_statement__ = 168;
    return dy_dt;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct TKTD_varSD_functor__ {
template <typename T0__, typename T1__, typename T2__, typename T3__>
Eigen::Matrix<stan::promote_args_t<T0__, stan::value_type_t<T1__>, T2__,
T3__>, -1, 1>
operator()(const T0__& t, const T1__& y, const std::vector<T2__>& theta,
           const std::vector<T3__>& x_r, const std::vector<int>& x_i,
           std::ostream* pstream__)  const 
{
return TKTD_varSD(t, y, theta, x_r, x_i, pstream__);
}
};
struct TKTD_varSD_odefunctor__ {
template <typename T0__, typename T1__, typename T2__, typename T3__>
Eigen::Matrix<stan::promote_args_t<T0__, stan::value_type_t<T1__>, T2__,
T3__>, -1, 1>
operator()(const T0__& t, const T1__& y, std::ostream* pstream__,
           const std::vector<T2__>& theta, const std::vector<T3__>& x_r,
           const std::vector<int>& x_i)  const 
{
return TKTD_varSD(t, y, theta, x_r, x_i, pstream__);
}
};
template <typename T0__, typename T1__, typename T2__, typename T3__>
Eigen::Matrix<stan::promote_args_t<T0__, T1__, T2__,
T3__>, -1, -1>
solve_TKTD_varSD(const std::vector<T0__>& y0, const T1__& t0,
                 const std::vector<T2__>& ts, const std::vector<T3__>& theta,
                 const std::vector<double>& tconc,
                 const std::vector<double>& conc, const double& relTol,
                 const double& absTol, const int& maxSteps,
                 std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__, T1__, T2__, T3__>;
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    std::vector<int> x_i;
    x_i = std::vector<int>(1, std::numeric_limits<int>::min());
    
    current_statement__ = 171;
    assign(x_i, cons_list(index_uni(1), nil_index_list()),
      stan::math::size(tconc), "assigning variable x_i");
    current_statement__ = 172;
    validate_non_negative_index("ode_res", "size(ts)", stan::math::size(ts));
    std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> ode_res;
    ode_res = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(stan::math::size(
                                                                    ts), Eigen::Matrix<local_scalar_t__, -1, 1>(2));
    stan::math::fill(ode_res, DUMMY_VAR__);
    
    current_statement__ = 173;
    assign(ode_res, nil_index_list(),
      ode_rk45_tol(TKTD_varSD_odefunctor__(), to_vector(y0), t0, ts, relTol,
        absTol, maxSteps, pstream__, theta,
        to_array_1d(append_row(to_vector(tconc), to_vector(conc))), x_i),
      "assigning variable ode_res");
    current_statement__ = 174;
    validate_non_negative_index("rtn", "size(ts)", stan::math::size(ts));
    Eigen::Matrix<local_scalar_t__, -1, -1> rtn;
    rtn = Eigen::Matrix<local_scalar_t__, -1, -1>(stan::math::size(ts), 2);
    stan::math::fill(rtn, DUMMY_VAR__);
    
    current_statement__ = 178;
    for (int i = 1; i <= stan::math::size(ts); ++i) {
      current_statement__ = 176;
      assign(rtn, cons_list(index_uni(i), nil_index_list()),
        transpose(ode_res[(i - 1)]), "assigning variable rtn");}
    current_statement__ = 179;
    return rtn;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct solve_TKTD_varSD_functor__ {
template <typename T0__, typename T1__, typename T2__, typename T3__>
Eigen::Matrix<stan::promote_args_t<T0__, T1__, T2__,
T3__>, -1, -1>
operator()(const std::vector<T0__>& y0, const T1__& t0,
           const std::vector<T2__>& ts, const std::vector<T3__>& theta,
           const std::vector<double>& tconc, const std::vector<double>& conc,
           const double& relTol, const double& absTol, const int& maxSteps,
           std::ostream* pstream__)  const 
{
return solve_TKTD_varSD(y0, t0, ts, theta, tconc, conc, relTol, absTol,
         maxSteps, pstream__);
}
};
#include <stan_meta_header.hpp>
class model_GUTS_SD final : public model_base_crtp<model_GUTS_SD> {
private:
  int nDatasets;
  int nGroup;
  std::vector<int> groupDataset;
  int nData_conc;
  std::vector<double> conc;
  std::vector<double> tconc;
  std::vector<int> idC_lw;
  std::vector<int> idC_up;
  int nData_Nsurv;
  std::vector<int> Nsurv;
  std::vector<int> Nprec;
  std::vector<double> tNsurv;
  std::vector<int> idS_lw;
  std::vector<int> idS_up;
  double hbMean_log10;
  double hbSD_log10;
  double kdMean_log10;
  double kdSD_log10;
  double relTol;
  double absTol;
  int maxSteps;
  double bwMean_log10;
  double bwSD_log10;
  double zwMean_log10;
  double zwSD_log10;
  std::vector<double> y0;
  std::vector<double> tNsurv_ode;
  std::vector<double> tconc_ode;
  int sigma_1dim__;
 
public:
  ~model_GUTS_SD() { }
  
  inline std::string model_name() const final { return "model_GUTS_SD"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_GUTS_SD(stan::io::var_context& context__,
                unsigned int random_seed__ = 0,
                std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_GUTS_SD_namespace::model_GUTS_SD";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 40;
      context__.validate_dims("data initialization","nDatasets","int",
          context__.to_vec());
      nDatasets = std::numeric_limits<int>::min();
      
      current_statement__ = 40;
      nDatasets = context__.vals_i("nDatasets")[(1 - 1)];
      current_statement__ = 40;
      current_statement__ = 40;
      check_greater_or_equal(function__, "nDatasets", nDatasets, 1);
      current_statement__ = 41;
      context__.validate_dims("data initialization","nGroup","int",
          context__.to_vec());
      nGroup = std::numeric_limits<int>::min();
      
      current_statement__ = 41;
      nGroup = context__.vals_i("nGroup")[(1 - 1)];
      current_statement__ = 41;
      current_statement__ = 41;
      check_greater_or_equal(function__, "nGroup", nGroup, 1);
      current_statement__ = 42;
      validate_non_negative_index("groupDataset", "nGroup", nGroup);
      current_statement__ = 43;
      context__.validate_dims("data initialization","groupDataset","int",
          context__.to_vec(nGroup));
      groupDataset = std::vector<int>(nGroup, std::numeric_limits<int>::min());
      
      current_statement__ = 43;
      assign(groupDataset, nil_index_list(),
        context__.vals_i("groupDataset"), "assigning variable groupDataset");
      current_statement__ = 44;
      context__.validate_dims("data initialization","nData_conc","int",
          context__.to_vec());
      nData_conc = std::numeric_limits<int>::min();
      
      current_statement__ = 44;
      nData_conc = context__.vals_i("nData_conc")[(1 - 1)];
      current_statement__ = 44;
      current_statement__ = 44;
      check_greater_or_equal(function__, "nData_conc", nData_conc, 1);
      current_statement__ = 45;
      validate_non_negative_index("conc", "nData_conc", nData_conc);
      current_statement__ = 46;
      context__.validate_dims("data initialization","conc","double",
          context__.to_vec(nData_conc));
      conc = std::vector<double>(nData_conc, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 46;
      assign(conc, nil_index_list(), context__.vals_r("conc"),
        "assigning variable conc");
      current_statement__ = 47;
      validate_non_negative_index("tconc", "nData_conc", nData_conc);
      current_statement__ = 48;
      context__.validate_dims("data initialization","tconc","double",
          context__.to_vec(nData_conc));
      tconc = std::vector<double>(nData_conc, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 48;
      assign(tconc, nil_index_list(), context__.vals_r("tconc"),
        "assigning variable tconc");
      current_statement__ = 49;
      validate_non_negative_index("idC_lw", "nGroup", nGroup);
      current_statement__ = 50;
      context__.validate_dims("data initialization","idC_lw","int",
          context__.to_vec(nGroup));
      idC_lw = std::vector<int>(nGroup, std::numeric_limits<int>::min());
      
      current_statement__ = 50;
      assign(idC_lw, nil_index_list(), context__.vals_i("idC_lw"),
        "assigning variable idC_lw");
      current_statement__ = 50;
      for (int sym1__ = 1; sym1__ <= nGroup; ++sym1__) {
        current_statement__ = 50;
        current_statement__ = 50;
        check_greater_or_equal(function__, "idC_lw[sym1__]",
                               idC_lw[(sym1__ - 1)], 1);}
      current_statement__ = 51;
      validate_non_negative_index("idC_up", "nGroup", nGroup);
      current_statement__ = 52;
      context__.validate_dims("data initialization","idC_up","int",
          context__.to_vec(nGroup));
      idC_up = std::vector<int>(nGroup, std::numeric_limits<int>::min());
      
      current_statement__ = 52;
      assign(idC_up, nil_index_list(), context__.vals_i("idC_up"),
        "assigning variable idC_up");
      current_statement__ = 52;
      for (int sym1__ = 1; sym1__ <= nGroup; ++sym1__) {
        current_statement__ = 52;
        current_statement__ = 52;
        check_greater_or_equal(function__, "idC_up[sym1__]",
                               idC_up[(sym1__ - 1)], 1);}
      current_statement__ = 53;
      context__.validate_dims("data initialization","nData_Nsurv","int",
          context__.to_vec());
      nData_Nsurv = std::numeric_limits<int>::min();
      
      current_statement__ = 53;
      nData_Nsurv = context__.vals_i("nData_Nsurv")[(1 - 1)];
      current_statement__ = 53;
      current_statement__ = 53;
      check_greater_or_equal(function__, "nData_Nsurv", nData_Nsurv, 1);
      current_statement__ = 54;
      validate_non_negative_index("Nsurv", "nData_Nsurv", nData_Nsurv);
      current_statement__ = 55;
      context__.validate_dims("data initialization","Nsurv","int",
          context__.to_vec(nData_Nsurv));
      Nsurv = std::vector<int>(nData_Nsurv, std::numeric_limits<int>::min());
      
      current_statement__ = 55;
      assign(Nsurv, nil_index_list(), context__.vals_i("Nsurv"),
        "assigning variable Nsurv");
      current_statement__ = 56;
      validate_non_negative_index("Nprec", "nData_Nsurv", nData_Nsurv);
      current_statement__ = 57;
      context__.validate_dims("data initialization","Nprec","int",
          context__.to_vec(nData_Nsurv));
      Nprec = std::vector<int>(nData_Nsurv, std::numeric_limits<int>::min());
      
      current_statement__ = 57;
      assign(Nprec, nil_index_list(), context__.vals_i("Nprec"),
        "assigning variable Nprec");
      current_statement__ = 58;
      validate_non_negative_index("tNsurv", "nData_Nsurv", nData_Nsurv);
      current_statement__ = 59;
      context__.validate_dims("data initialization","tNsurv","double",
          context__.to_vec(nData_Nsurv));
      tNsurv = std::vector<double>(nData_Nsurv, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 59;
      assign(tNsurv, nil_index_list(), context__.vals_r("tNsurv"),
        "assigning variable tNsurv");
      current_statement__ = 60;
      validate_non_negative_index("idS_lw", "nGroup", nGroup);
      current_statement__ = 61;
      context__.validate_dims("data initialization","idS_lw","int",
          context__.to_vec(nGroup));
      idS_lw = std::vector<int>(nGroup, std::numeric_limits<int>::min());
      
      current_statement__ = 61;
      assign(idS_lw, nil_index_list(), context__.vals_i("idS_lw"),
        "assigning variable idS_lw");
      current_statement__ = 61;
      for (int sym1__ = 1; sym1__ <= nGroup; ++sym1__) {
        current_statement__ = 61;
        current_statement__ = 61;
        check_greater_or_equal(function__, "idS_lw[sym1__]",
                               idS_lw[(sym1__ - 1)], 1);}
      current_statement__ = 62;
      validate_non_negative_index("idS_up", "nGroup", nGroup);
      current_statement__ = 63;
      context__.validate_dims("data initialization","idS_up","int",
          context__.to_vec(nGroup));
      idS_up = std::vector<int>(nGroup, std::numeric_limits<int>::min());
      
      current_statement__ = 63;
      assign(idS_up, nil_index_list(), context__.vals_i("idS_up"),
        "assigning variable idS_up");
      current_statement__ = 63;
      for (int sym1__ = 1; sym1__ <= nGroup; ++sym1__) {
        current_statement__ = 63;
        current_statement__ = 63;
        check_greater_or_equal(function__, "idS_up[sym1__]",
                               idS_up[(sym1__ - 1)], 1);}
      current_statement__ = 64;
      context__.validate_dims("data initialization","hbMean_log10","double",
          context__.to_vec());
      hbMean_log10 = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 64;
      hbMean_log10 = context__.vals_r("hbMean_log10")[(1 - 1)];
      current_statement__ = 65;
      context__.validate_dims("data initialization","hbSD_log10","double",
          context__.to_vec());
      hbSD_log10 = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 65;
      hbSD_log10 = context__.vals_r("hbSD_log10")[(1 - 1)];
      current_statement__ = 66;
      context__.validate_dims("data initialization","kdMean_log10","double",
          context__.to_vec());
      kdMean_log10 = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 66;
      kdMean_log10 = context__.vals_r("kdMean_log10")[(1 - 1)];
      current_statement__ = 67;
      context__.validate_dims("data initialization","kdSD_log10","double",
          context__.to_vec());
      kdSD_log10 = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 67;
      kdSD_log10 = context__.vals_r("kdSD_log10")[(1 - 1)];
      current_statement__ = 68;
      context__.validate_dims("data initialization","relTol","double",
          context__.to_vec());
      relTol = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 68;
      relTol = context__.vals_r("relTol")[(1 - 1)];
      current_statement__ = 69;
      context__.validate_dims("data initialization","absTol","double",
          context__.to_vec());
      absTol = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 69;
      absTol = context__.vals_r("absTol")[(1 - 1)];
      current_statement__ = 70;
      context__.validate_dims("data initialization","maxSteps","int",
          context__.to_vec());
      maxSteps = std::numeric_limits<int>::min();
      
      current_statement__ = 70;
      maxSteps = context__.vals_i("maxSteps")[(1 - 1)];
      current_statement__ = 71;
      context__.validate_dims("data initialization","bwMean_log10","double",
          context__.to_vec());
      bwMean_log10 = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 71;
      bwMean_log10 = context__.vals_r("bwMean_log10")[(1 - 1)];
      current_statement__ = 72;
      context__.validate_dims("data initialization","bwSD_log10","double",
          context__.to_vec());
      bwSD_log10 = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 72;
      bwSD_log10 = context__.vals_r("bwSD_log10")[(1 - 1)];
      current_statement__ = 73;
      context__.validate_dims("data initialization","zwMean_log10","double",
          context__.to_vec());
      zwMean_log10 = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 73;
      zwMean_log10 = context__.vals_r("zwMean_log10")[(1 - 1)];
      current_statement__ = 74;
      context__.validate_dims("data initialization","zwSD_log10","double",
          context__.to_vec());
      zwSD_log10 = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 74;
      zwSD_log10 = context__.vals_r("zwSD_log10")[(1 - 1)];
      current_statement__ = 75;
      y0 = std::vector<double>(2, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 76;
      validate_non_negative_index("tNsurv_ode", "nData_Nsurv", nData_Nsurv);
      current_statement__ = 77;
      tNsurv_ode = std::vector<double>(nData_Nsurv, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 78;
      validate_non_negative_index("tconc_ode", "nData_conc", nData_conc);
      current_statement__ = 79;
      tconc_ode = std::vector<double>(nData_conc, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 80;
      assign(y0, cons_list(index_uni(1), nil_index_list()), 0,
        "assigning variable y0");
      current_statement__ = 81;
      assign(y0, cons_list(index_uni(2), nil_index_list()), 0,
        "assigning variable y0");
      current_statement__ = 87;
      for (int gr = 1; gr <= nGroup; ++gr) {
        current_statement__ = 82;
        assign(tNsurv_ode,
          cons_list(index_min_max(idS_lw[(gr - 1)], idS_up[(gr - 1)]),
            nil_index_list()),
          rvalue(tNsurv,
            cons_list(index_min_max(idS_lw[(gr - 1)], idS_up[(gr - 1)]),
              nil_index_list()), "tNsurv"), "assigning variable tNsurv_ode");
        current_statement__ = 83;
        assign(tNsurv_ode,
          cons_list(index_uni(idS_lw[(gr - 1)]), nil_index_list()),
          (tNsurv[(idS_lw[(gr - 1)] - 1)] + 1e-9),
          "assigning variable tNsurv_ode");
        current_statement__ = 84;
        assign(tconc_ode,
          cons_list(index_min_max(idC_lw[(gr - 1)], idC_up[(gr - 1)]),
            nil_index_list()),
          rvalue(tconc,
            cons_list(index_min_max(idC_lw[(gr - 1)], idC_up[(gr - 1)]),
              nil_index_list()), "tconc"), "assigning variable tconc_ode");
        current_statement__ = 85;
        assign(tconc_ode,
          cons_list(index_uni(idC_lw[(gr - 1)]), nil_index_list()),
          (tconc[(idC_lw[(gr - 1)] - 1)] + 1e-9),
          "assigning variable tconc_ode");}
      current_statement__ = 75;
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        current_statement__ = 75;
        current_statement__ = 75;
        check_greater_or_equal(function__, "y0[sym1__]", y0[(sym1__ - 1)], 0);
      }
      current_statement__ = 88;
      sigma_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 88;
      sigma_1dim__ = (3 + nDatasets);
      current_statement__ = 88;
      validate_non_negative_index("sigma", "3 + nDatasets", sigma_1dim__);
      current_statement__ = 89;
      validate_non_negative_index("hb_log10", "nDatasets", nDatasets);
      current_statement__ = 90;
      validate_non_negative_index("y_hat", "nData_Nsurv", nData_Nsurv);
      current_statement__ = 91;
      validate_non_negative_index("Psurv_hat", "nData_Nsurv", nData_Nsurv);
      current_statement__ = 92;
      validate_non_negative_index("Conditional_Psurv_hat", "nData_Nsurv",
                                  nData_Nsurv);
      current_statement__ = 93;
      validate_non_negative_index("Nsurv_ppc", "nData_Nsurv", nData_Nsurv);
      current_statement__ = 94;
      validate_non_negative_index("Nsurv_sim", "nData_Nsurv", nData_Nsurv);
      current_statement__ = 95;
      validate_non_negative_index("Nsurv_sim_prec", "nData_Nsurv",
                                  nData_Nsurv);
      current_statement__ = 96;
      validate_non_negative_index("log_lik", "nData_Nsurv", nData_Nsurv);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += sigma_1dim__;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_GUTS_SD_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      std::vector<local_scalar_t__> sigma;
      sigma = std::vector<local_scalar_t__>(sigma_1dim__, DUMMY_VAR__);
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= sigma_1dim__; ++sym1__) {
        current_statement__ = 1;
        assign(sigma, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable sigma");}
      local_scalar_t__ kd_log10;
      kd_log10 = DUMMY_VAR__;
      
      current_statement__ = 2;
      kd_log10 = (kdMean_log10 + (kdSD_log10 * sigma[(1 - 1)]));
      local_scalar_t__ zw_log10;
      zw_log10 = DUMMY_VAR__;
      
      current_statement__ = 3;
      zw_log10 = (zwMean_log10 + (zwSD_log10 * sigma[(2 - 1)]));
      local_scalar_t__ bw_log10;
      bw_log10 = DUMMY_VAR__;
      
      current_statement__ = 4;
      bw_log10 = (bwMean_log10 + (bwSD_log10 * sigma[(3 - 1)]));
      std::vector<local_scalar_t__> hb_log10;
      hb_log10 = std::vector<local_scalar_t__>(nDatasets, DUMMY_VAR__);
      
      std::vector<local_scalar_t__> param;
      param = std::vector<local_scalar_t__>(4, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, -1> y_hat;
      y_hat = Eigen::Matrix<local_scalar_t__, -1, -1>(nData_Nsurv, 2);
      stan::math::fill(y_hat, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> Psurv_hat;
      Psurv_hat = Eigen::Matrix<local_scalar_t__, -1, 1>(nData_Nsurv);
      stan::math::fill(Psurv_hat, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> Conditional_Psurv_hat;
      Conditional_Psurv_hat = Eigen::Matrix<local_scalar_t__, -1, 1>(nData_Nsurv);
      stan::math::fill(Conditional_Psurv_hat, DUMMY_VAR__);
      
      current_statement__ = 10;
      assign(param, cons_list(index_uni(1), nil_index_list()),
        pow(10, kd_log10), "assigning variable param");
      current_statement__ = 11;
      assign(param, cons_list(index_uni(2), nil_index_list()),
        pow(10, zw_log10), "assigning variable param");
      current_statement__ = 12;
      assign(param, cons_list(index_uni(3), nil_index_list()),
        pow(10, bw_log10), "assigning variable param");
      current_statement__ = 15;
      for (int i = 1; i <= nDatasets; ++i) {
        current_statement__ = 13;
        assign(hb_log10, cons_list(index_uni(i), nil_index_list()),
          (hbMean_log10 + (hbSD_log10 * sigma[((3 + i) - 1)])),
          "assigning variable hb_log10");}
      current_statement__ = 23;
      for (int gr = 1; gr <= nGroup; ++gr) {
        current_statement__ = 16;
        assign(param, cons_list(index_uni(4), nil_index_list()),
          pow(10, hb_log10[(groupDataset[(gr - 1)] - 1)]),
          "assigning variable param");
        current_statement__ = 17;
        assign(y_hat,
          cons_list(index_min_max(idS_lw[(gr - 1)], idS_up[(gr - 1)]),
            cons_list(index_min_max(1, 2), nil_index_list())),
          solve_TKTD_varSD(y0, 0,
            rvalue(tNsurv_ode,
              cons_list(index_min_max(idS_lw[(gr - 1)], idS_up[(gr - 1)]),
                nil_index_list()), "tNsurv_ode"), param,
            rvalue(tconc_ode,
              cons_list(index_min_max(idC_lw[(gr - 1)], idC_up[(gr - 1)]),
                nil_index_list()), "tconc_ode"),
            rvalue(conc,
              cons_list(index_min_max(idC_lw[(gr - 1)], idC_up[(gr - 1)]),
                nil_index_list()), "conc"), relTol, absTol,
            maxSteps, pstream__), "assigning variable y_hat");
        current_statement__ = 18;
        assign(Psurv_hat,
          cons_list(index_min_max(idS_lw[(gr - 1)], idS_up[(gr - 1)]),
            nil_index_list()),
          stan::math::exp(
            minus(
              rvalue(y_hat,
                cons_list(index_min_max(idS_lw[(gr - 1)], idS_up[(gr - 1)]),
                  cons_list(index_uni(2), nil_index_list())), "y_hat"))),
          "assigning variable Psurv_hat");
        current_statement__ = 21;
        for (int i = idS_lw[(gr - 1)]; i <= idS_up[(gr - 1)]; ++i) {
          current_statement__ = 19;
          assign(Conditional_Psurv_hat,
            cons_list(index_uni(i), nil_index_list()),
            (logical_eq(i, idS_lw[(gr - 1)]) ? Psurv_hat[(i - 1)] :
               (Psurv_hat[(i - 1)] / Psurv_hat[((i - 1) - 1)])),
            "assigning variable Conditional_Psurv_hat");}}
      current_statement__ = 6;
      for (int sym1__ = 1; sym1__ <= 4; ++sym1__) {
        current_statement__ = 6;
        current_statement__ = 6;
        check_greater_or_equal(function__, "param[sym1__]",
                               param[(sym1__ - 1)], 0);}
      current_statement__ = 8;
      for (int sym1__ = 1; sym1__ <= nData_Nsurv; ++sym1__) {
        current_statement__ = 8;
        current_statement__ = 8;
        check_greater_or_equal(function__, "Psurv_hat[sym1__]",
                               Psurv_hat[(sym1__ - 1)], 0);}
      current_statement__ = 8;
      for (int sym1__ = 1; sym1__ <= nData_Nsurv; ++sym1__) {
        current_statement__ = 8;
        current_statement__ = 8;
        check_less_or_equal(function__, "Psurv_hat[sym1__]",
                            Psurv_hat[(sym1__ - 1)], 1);}
      current_statement__ = 9;
      for (int sym1__ = 1; sym1__ <= nData_Nsurv; ++sym1__) {
        current_statement__ = 9;
        current_statement__ = 9;
        check_greater_or_equal(function__, "Conditional_Psurv_hat[sym1__]",
                               Conditional_Psurv_hat[(sym1__ - 1)], 0);}
      current_statement__ = 9;
      for (int sym1__ = 1; sym1__ <= nData_Nsurv; ++sym1__) {
        current_statement__ = 9;
        current_statement__ = 9;
        check_less_or_equal(function__, "Conditional_Psurv_hat[sym1__]",
                            Conditional_Psurv_hat[(sym1__ - 1)], 1);}
      {
        current_statement__ = 36;
        lp_accum__.add(normal_lpdf<false>(sigma, 0, 1));
        current_statement__ = 39;
        for (int gr = 1; gr <= nGroup; ++gr) {
          current_statement__ = 37;
          lp_accum__.add(
            binomial_lpmf<false>(
              rvalue(Nsurv,
                cons_list(index_min_max(idS_lw[(gr - 1)], idS_up[(gr - 1)]),
                  nil_index_list()), "Nsurv"),
              rvalue(Nprec,
                cons_list(index_min_max(idS_lw[(gr - 1)], idS_up[(gr - 1)]),
                  nil_index_list()), "Nprec"),
              rvalue(Conditional_Psurv_hat,
                cons_list(index_min_max(idS_lw[(gr - 1)], idS_up[(gr - 1)]),
                  nil_index_list()), "Conditional_Psurv_hat")));}
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_GUTS_SD_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      std::vector<double> sigma;
      sigma = std::vector<double>(sigma_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= sigma_1dim__; ++sym1__) {
        current_statement__ = 1;
        assign(sigma, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable sigma");}
      double kd_log10;
      kd_log10 = std::numeric_limits<double>::quiet_NaN();
      
      double zw_log10;
      zw_log10 = std::numeric_limits<double>::quiet_NaN();
      
      double bw_log10;
      bw_log10 = std::numeric_limits<double>::quiet_NaN();
      
      std::vector<double> hb_log10;
      hb_log10 = std::vector<double>(nDatasets, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<double> param;
      param = std::vector<double>(4, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, -1> y_hat;
      y_hat = Eigen::Matrix<double, -1, -1>(nData_Nsurv, 2);
      stan::math::fill(y_hat, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> Psurv_hat;
      Psurv_hat = Eigen::Matrix<double, -1, 1>(nData_Nsurv);
      stan::math::fill(Psurv_hat, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> Conditional_Psurv_hat;
      Conditional_Psurv_hat = Eigen::Matrix<double, -1, 1>(nData_Nsurv);
      stan::math::fill(Conditional_Psurv_hat, std::numeric_limits<double>::quiet_NaN());
      
      for (int sym1__ = 1; sym1__ <= sigma_1dim__; ++sym1__) {
        vars__.emplace_back(sigma[(sym1__ - 1)]);}
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      current_statement__ = 2;
      kd_log10 = (kdMean_log10 + (kdSD_log10 * sigma[(1 - 1)]));
      current_statement__ = 3;
      zw_log10 = (zwMean_log10 + (zwSD_log10 * sigma[(2 - 1)]));
      current_statement__ = 4;
      bw_log10 = (bwMean_log10 + (bwSD_log10 * sigma[(3 - 1)]));
      current_statement__ = 10;
      assign(param, cons_list(index_uni(1), nil_index_list()),
        pow(10, kd_log10), "assigning variable param");
      current_statement__ = 11;
      assign(param, cons_list(index_uni(2), nil_index_list()),
        pow(10, zw_log10), "assigning variable param");
      current_statement__ = 12;
      assign(param, cons_list(index_uni(3), nil_index_list()),
        pow(10, bw_log10), "assigning variable param");
      current_statement__ = 15;
      for (int i = 1; i <= nDatasets; ++i) {
        current_statement__ = 13;
        assign(hb_log10, cons_list(index_uni(i), nil_index_list()),
          (hbMean_log10 + (hbSD_log10 * sigma[((3 + i) - 1)])),
          "assigning variable hb_log10");}
      current_statement__ = 23;
      for (int gr = 1; gr <= nGroup; ++gr) {
        current_statement__ = 16;
        assign(param, cons_list(index_uni(4), nil_index_list()),
          pow(10, hb_log10[(groupDataset[(gr - 1)] - 1)]),
          "assigning variable param");
        current_statement__ = 17;
        assign(y_hat,
          cons_list(index_min_max(idS_lw[(gr - 1)], idS_up[(gr - 1)]),
            cons_list(index_min_max(1, 2), nil_index_list())),
          solve_TKTD_varSD(y0, 0,
            rvalue(tNsurv_ode,
              cons_list(index_min_max(idS_lw[(gr - 1)], idS_up[(gr - 1)]),
                nil_index_list()), "tNsurv_ode"), param,
            rvalue(tconc_ode,
              cons_list(index_min_max(idC_lw[(gr - 1)], idC_up[(gr - 1)]),
                nil_index_list()), "tconc_ode"),
            rvalue(conc,
              cons_list(index_min_max(idC_lw[(gr - 1)], idC_up[(gr - 1)]),
                nil_index_list()), "conc"), relTol, absTol,
            maxSteps, pstream__), "assigning variable y_hat");
        current_statement__ = 18;
        assign(Psurv_hat,
          cons_list(index_min_max(idS_lw[(gr - 1)], idS_up[(gr - 1)]),
            nil_index_list()),
          stan::math::exp(
            minus(
              rvalue(y_hat,
                cons_list(index_min_max(idS_lw[(gr - 1)], idS_up[(gr - 1)]),
                  cons_list(index_uni(2), nil_index_list())), "y_hat"))),
          "assigning variable Psurv_hat");
        current_statement__ = 21;
        for (int i = idS_lw[(gr - 1)]; i <= idS_up[(gr - 1)]; ++i) {
          current_statement__ = 19;
          assign(Conditional_Psurv_hat,
            cons_list(index_uni(i), nil_index_list()),
            (logical_eq(i, idS_lw[(gr - 1)]) ? Psurv_hat[(i - 1)] :
               (Psurv_hat[(i - 1)] / Psurv_hat[((i - 1) - 1)])),
            "assigning variable Conditional_Psurv_hat");}}
      current_statement__ = 6;
      for (int sym1__ = 1; sym1__ <= 4; ++sym1__) {
        current_statement__ = 6;
        current_statement__ = 6;
        check_greater_or_equal(function__, "param[sym1__]",
                               param[(sym1__ - 1)], 0);}
      current_statement__ = 8;
      for (int sym1__ = 1; sym1__ <= nData_Nsurv; ++sym1__) {
        current_statement__ = 8;
        current_statement__ = 8;
        check_greater_or_equal(function__, "Psurv_hat[sym1__]",
                               Psurv_hat[(sym1__ - 1)], 0);}
      current_statement__ = 8;
      for (int sym1__ = 1; sym1__ <= nData_Nsurv; ++sym1__) {
        current_statement__ = 8;
        current_statement__ = 8;
        check_less_or_equal(function__, "Psurv_hat[sym1__]",
                            Psurv_hat[(sym1__ - 1)], 1);}
      current_statement__ = 9;
      for (int sym1__ = 1; sym1__ <= nData_Nsurv; ++sym1__) {
        current_statement__ = 9;
        current_statement__ = 9;
        check_greater_or_equal(function__, "Conditional_Psurv_hat[sym1__]",
                               Conditional_Psurv_hat[(sym1__ - 1)], 0);}
      current_statement__ = 9;
      for (int sym1__ = 1; sym1__ <= nData_Nsurv; ++sym1__) {
        current_statement__ = 9;
        current_statement__ = 9;
        check_less_or_equal(function__, "Conditional_Psurv_hat[sym1__]",
                            Conditional_Psurv_hat[(sym1__ - 1)], 1);}
      if (emit_transformed_parameters__) {
        vars__.emplace_back(kd_log10);
        vars__.emplace_back(zw_log10);
        vars__.emplace_back(bw_log10);
        for (int sym1__ = 1; sym1__ <= nDatasets; ++sym1__) {
          vars__.emplace_back(hb_log10[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= 4; ++sym1__) {
          vars__.emplace_back(param[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= nData_Nsurv; ++sym2__) {
            vars__.emplace_back(
              rvalue(y_hat,
                cons_list(index_uni(sym2__),
                  cons_list(index_uni(sym1__), nil_index_list())), "y_hat"));
          }}
        for (int sym1__ = 1; sym1__ <= nData_Nsurv; ++sym1__) {
          vars__.emplace_back(Psurv_hat[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= nData_Nsurv; ++sym1__) {
          vars__.emplace_back(Conditional_Psurv_hat[(sym1__ - 1)]);}
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
      std::vector<int> Nsurv_ppc;
      Nsurv_ppc = std::vector<int>(nData_Nsurv, std::numeric_limits<int>::min());
      
      std::vector<int> Nsurv_sim;
      Nsurv_sim = std::vector<int>(nData_Nsurv, std::numeric_limits<int>::min());
      
      std::vector<int> Nsurv_sim_prec;
      Nsurv_sim_prec = std::vector<int>(nData_Nsurv, std::numeric_limits<int>::min());
      
      Eigen::Matrix<double, -1, 1> log_lik;
      log_lik = Eigen::Matrix<double, -1, 1>(nData_Nsurv);
      stan::math::fill(log_lik, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 35;
      for (int gr = 1; gr <= nGroup; ++gr) {
        current_statement__ = 33;
        for (int i = idS_lw[(gr - 1)]; i <= idS_up[(gr - 1)]; ++i) {
          current_statement__ = 28;
          assign(Nsurv_ppc, cons_list(index_uni(i), nil_index_list()),
            binomial_rng(Nprec[(i - 1)], Conditional_Psurv_hat[(i - 1)],
              base_rng__), "assigning variable Nsurv_ppc");
          current_statement__ = 29;
          assign(Nsurv_sim_prec, cons_list(index_uni(i), nil_index_list()),
            (logical_eq(i, idS_lw[(gr - 1)]) ? Nprec[(i - 1)] :
               Nsurv_sim[((i - 1) - 1)]), "assigning variable Nsurv_sim_prec");
          current_statement__ = 30;
          assign(Nsurv_sim, cons_list(index_uni(i), nil_index_list()),
            binomial_rng(Nsurv_sim_prec[(i - 1)],
              Conditional_Psurv_hat[(i - 1)], base_rng__),
            "assigning variable Nsurv_sim");
          current_statement__ = 31;
          assign(log_lik, cons_list(index_uni(i), nil_index_list()),
            binomial_lpmf<false>(
              rvalue(Nsurv,
                cons_list(index_min_max(idS_lw[(gr - 1)], idS_up[(gr - 1)]),
                  nil_index_list()), "Nsurv"),
              rvalue(Nprec,
                cons_list(index_min_max(idS_lw[(gr - 1)], idS_up[(gr - 1)]),
                  nil_index_list()), "Nprec"),
              rvalue(Conditional_Psurv_hat,
                cons_list(index_min_max(idS_lw[(gr - 1)], idS_up[(gr - 1)]),
                  nil_index_list()), "Conditional_Psurv_hat")),
            "assigning variable log_lik");}}
      for (int sym1__ = 1; sym1__ <= nData_Nsurv; ++sym1__) {
        vars__.emplace_back(Nsurv_ppc[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nData_Nsurv; ++sym1__) {
        vars__.emplace_back(Nsurv_sim[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nData_Nsurv; ++sym1__) {
        vars__.emplace_back(Nsurv_sim_prec[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nData_Nsurv; ++sym1__) {
        vars__.emplace_back(log_lik[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      std::vector<double> sigma;
      sigma = std::vector<double>(sigma_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      assign(sigma, nil_index_list(), context__.vals_r("sigma"),
        "assigning variable sigma");
      for (int sym1__ = 1; sym1__ <= sigma_1dim__; ++sym1__) {
        vars__.emplace_back(sigma[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("sigma");
    names__.emplace_back("kd_log10");
    names__.emplace_back("zw_log10");
    names__.emplace_back("bw_log10");
    names__.emplace_back("hb_log10");
    names__.emplace_back("param");
    names__.emplace_back("y_hat");
    names__.emplace_back("Psurv_hat");
    names__.emplace_back("Conditional_Psurv_hat");
    names__.emplace_back("Nsurv_ppc");
    names__.emplace_back("Nsurv_sim");
    names__.emplace_back("Nsurv_sim_prec");
    names__.emplace_back("log_lik");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(sigma_1dim__)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nDatasets)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(4)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nData_Nsurv)
                                             , static_cast<size_t>(2)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nData_Nsurv)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nData_Nsurv)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nData_Nsurv)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nData_Nsurv)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nData_Nsurv)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nData_Nsurv)});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= sigma_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "sigma" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      param_names__.emplace_back(std::string() + "kd_log10");
      param_names__.emplace_back(std::string() + "zw_log10");
      param_names__.emplace_back(std::string() + "bw_log10");
      for (int sym1__ = 1; sym1__ <= nDatasets; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "hb_log10" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= 4; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "param" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nData_Nsurv; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "y_hat" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nData_Nsurv; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "Psurv_hat" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= nData_Nsurv; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "Conditional_Psurv_hat" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= nData_Nsurv; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "Nsurv_ppc" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= nData_Nsurv; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "Nsurv_sim" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= nData_Nsurv; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "Nsurv_sim_prec" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= nData_Nsurv; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_lik" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= sigma_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "sigma" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      param_names__.emplace_back(std::string() + "kd_log10");
      param_names__.emplace_back(std::string() + "zw_log10");
      param_names__.emplace_back(std::string() + "bw_log10");
      for (int sym1__ = 1; sym1__ <= nDatasets; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "hb_log10" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= 4; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "param" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nData_Nsurv; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "y_hat" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nData_Nsurv; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "Psurv_hat" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= nData_Nsurv; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "Conditional_Psurv_hat" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= nData_Nsurv; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "Nsurv_ppc" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= nData_Nsurv; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "Nsurv_sim" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= nData_Nsurv; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "Nsurv_sim_prec" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= nData_Nsurv; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_lik" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"sigma\",\"type\":{\"name\":\"array\",\"length\":" << sigma_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"kd_log10\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"zw_log10\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"bw_log10\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"hb_log10\",\"type\":{\"name\":\"array\",\"length\":" << nDatasets << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"},{\"name\":\"param\",\"type\":{\"name\":\"array\",\"length\":" << 4 << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"},{\"name\":\"y_hat\",\"type\":{\"name\":\"matrix\",\"rows\":" << nData_Nsurv << ",\"cols\":" << 2 << "},\"block\":\"transformed_parameters\"},{\"name\":\"Psurv_hat\",\"type\":{\"name\":\"vector\",\"length\":" << nData_Nsurv << "},\"block\":\"transformed_parameters\"},{\"name\":\"Conditional_Psurv_hat\",\"type\":{\"name\":\"vector\",\"length\":" << nData_Nsurv << "},\"block\":\"transformed_parameters\"},{\"name\":\"Nsurv_ppc\",\"type\":{\"name\":\"array\",\"length\":" << nData_Nsurv << ",\"element_type\":{\"name\":\"int\"}},\"block\":\"generated_quantities\"},{\"name\":\"Nsurv_sim\",\"type\":{\"name\":\"array\",\"length\":" << nData_Nsurv << ",\"element_type\":{\"name\":\"int\"}},\"block\":\"generated_quantities\"},{\"name\":\"Nsurv_sim_prec\",\"type\":{\"name\":\"array\",\"length\":" << nData_Nsurv << ",\"element_type\":{\"name\":\"int\"}},\"block\":\"generated_quantities\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" << nData_Nsurv << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"sigma\",\"type\":{\"name\":\"array\",\"length\":" << sigma_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"kd_log10\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"zw_log10\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"bw_log10\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"hb_log10\",\"type\":{\"name\":\"array\",\"length\":" << nDatasets << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"},{\"name\":\"param\",\"type\":{\"name\":\"array\",\"length\":" << 4 << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"},{\"name\":\"y_hat\",\"type\":{\"name\":\"matrix\",\"rows\":" << nData_Nsurv << ",\"cols\":" << 2 << "},\"block\":\"transformed_parameters\"},{\"name\":\"Psurv_hat\",\"type\":{\"name\":\"vector\",\"length\":" << nData_Nsurv << "},\"block\":\"transformed_parameters\"},{\"name\":\"Conditional_Psurv_hat\",\"type\":{\"name\":\"vector\",\"length\":" << nData_Nsurv << "},\"block\":\"transformed_parameters\"},{\"name\":\"Nsurv_ppc\",\"type\":{\"name\":\"array\",\"length\":" << nData_Nsurv << ",\"element_type\":{\"name\":\"int\"}},\"block\":\"generated_quantities\"},{\"name\":\"Nsurv_sim\",\"type\":{\"name\":\"array\",\"length\":" << nData_Nsurv << ",\"element_type\":{\"name\":\"int\"}},\"block\":\"generated_quantities\"},{\"name\":\"Nsurv_sim_prec\",\"type\":{\"name\":\"array\",\"length\":" << nData_Nsurv << ",\"element_type\":{\"name\":\"int\"}},\"block\":\"generated_quantities\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" << nData_Nsurv << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_GUTS_SD_namespace::model_GUTS_SD;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_GUTS_SD_namespace::profiles__;
}
#endif
#endif
