/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.indel;

import dr.evolution.alignment.Alignment;
import dr.evolution.alignment.SimpleAlignment;
import dr.evolution.datatype.DataType;
import dr.evolution.sequence.Sequence;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.tree.TreeModel;
import dr.inference.operators.SimpleMCMCOperator;
import dr.oldevomodel.indel.IstvansProposal;
import dr.oldevomodel.indel.TKF91Likelihood;
import dr.oldevomodel.substmodel.SubstitutionModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class IstvanOperator
extends SimpleMCMCOperator {
    private double tuning = 0.1;
    private double exponent = 1.5;
    private double gapPenalty = -10.0;
    private TKF91Likelihood likelihood;
    private IstvansProposal proposal = new IstvansProposal();
    private Alignment alignment;
    int[][] iAlignment;
    double[][][] iProbs;
    double[] iBaseFreqs;
    int[] iParent;
    double[] iTau;

    public IstvanOperator(double d, double d2, double d3, double d4, TKF91Likelihood tKF91Likelihood) {
        this.tuning = d;
        this.exponent = d2;
        this.gapPenalty = d3;
        this.likelihood = tKF91Likelihood;
        this.setWeight(d4);
    }

    @Override
    public double doOperation() {
        TreeModel treeModel = this.likelihood.getTreeModel();
        this.alignment = this.likelihood.getAlignment();
        SubstitutionModel substitutionModel = this.likelihood.getSiteModel().getSubstitutionModel();
        this.initTree(treeModel, this.likelihood.getSiteModel().getMu());
        int[] nArray = new int[treeModel.getTaxonCount()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = treeModel.getTaxonIndex(this.alignment.getTaxonId(i));
        }
        this.initAlignment(this.alignment, nArray);
        this.initSubstitutionModel(substitutionModel);
        DataType dataType = substitutionModel.getDataType();
        this.proposal.setGapSymbol(dataType.getGapState());
        int[][] nArrayArray = new int[this.iAlignment.length][];
        double d = this.proposal.propose(this.iAlignment, this.iProbs, this.iBaseFreqs, this.iParent, this.iTau, nArrayArray, this.tuning, this.exponent, this.gapPenalty);
        SimpleAlignment simpleAlignment = new SimpleAlignment();
        for (int i = 0; i < this.alignment.getTaxonCount(); ++i) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int j = 0; j < nArrayArray[i].length; ++j) {
                stringBuffer.append(dataType.getChar(nArrayArray[nArray[i]][j]));
            }
            String string = stringBuffer.toString();
            Sequence sequence = new Sequence(this.alignment.getTaxon(i), string);
            simpleAlignment.addSequence(sequence);
            String string2 = this.alignment.getUnalignedSequenceString(i);
            String string3 = simpleAlignment.getUnalignedSequenceString(i);
            if (string3.equals(string2)) continue;
            System.err.println("Sequence changed from:");
            System.err.println("old:'" + string2 + "'");
            System.err.println("new:'" + string3 + "'");
            throw new RuntimeException();
        }
        this.likelihood.setAlignment(simpleAlignment);
        return d;
    }

    @Override
    public void reject() {
        super.reject();
        this.likelihood.setAlignment(this.alignment);
    }

    private void initTree(Tree tree, double d) {
        this.iParent = new int[tree.getNodeCount()];
        this.iTau = new double[tree.getNodeCount() - 1];
        this.populate(tree, tree.getRoot(), new int[]{tree.getExternalNodeCount()}, d);
        this.iParent[tree.getNodeCount() - 1] = -1;
    }

    private void initSubstitutionModel(SubstitutionModel substitutionModel) {
        int n;
        DataType dataType = substitutionModel.getDataType();
        int n2 = dataType.getStateCount();
        this.iProbs = new double[this.iTau.length][n2][n2];
        double[] dArray = new double[n2 * n2];
        for (n = 0; n < this.iTau.length; ++n) {
            substitutionModel.getTransitionProbabilities(this.iTau[n], dArray);
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n2; ++j) {
                    this.iProbs[n][i][j] = dArray[n3];
                    ++n3;
                }
            }
        }
        this.iBaseFreqs = new double[n2];
        for (n = 0; n < n2; ++n) {
            this.iBaseFreqs[n] = substitutionModel.getFrequencyModel().getFrequency(n);
        }
    }

    private void initAlignment(Alignment alignment, int[] nArray) {
        int n = alignment.getSequenceCount();
        int n2 = alignment.getSiteCount();
        DataType dataType = alignment.getDataType();
        int n3 = dataType.getStateCount();
        this.iAlignment = new int[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.iAlignment[nArray[i]][j] = alignment.getState(i, j);
            }
        }
    }

    private int populate(Tree tree, NodeRef nodeRef, int[] nArray, double d) {
        int n;
        int n2 = nodeRef.getNumber();
        if (tree.isExternal(nodeRef)) {
            this.iTau[n2] = (tree.getNodeHeight(tree.getParent(nodeRef)) - tree.getNodeHeight(nodeRef)) * d;
            return n2;
        }
        int[] nArray2 = new int[tree.getChildCount(nodeRef)];
        for (n = 0; n < tree.getChildCount(nodeRef); ++n) {
            nArray2[n] = this.populate(tree, tree.getChild(nodeRef, n), nArray, d);
        }
        n2 = nArray[0];
        if (!tree.isRoot(nodeRef)) {
            this.iTau[n2] = (tree.getNodeHeight(tree.getParent(nodeRef)) - tree.getNodeHeight(nodeRef)) * d;
        }
        nArray[0] = nArray[0] + 1;
        for (n = 0; n < tree.getChildCount(nodeRef); ++n) {
            this.iParent[nArray2[n]] = n2;
        }
        return n2;
    }

    @Override
    public String getOperatorName() {
        return "IstvansOperator";
    }

    public double getMinimumAcceptanceLevel() {
        return 0.1;
    }

    public double getMinimumGoodAcceptanceLevel() {
        return 0.4;
    }

    public Element createOperatorElement(Document document) {
        throw new RuntimeException();
    }
}

