/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.distribution.DistributionLikelihood;
import dr.inference.model.Parameter;
import java.util.ArrayList;

public class TruncatedDistributionLikelihood
extends DistributionLikelihood {
    Parameter low;
    Parameter high;

    public TruncatedDistributionLikelihood(DistributionLikelihood distributionLikelihood, Parameter parameter, Parameter parameter2) {
        super(distributionLikelihood.getDistribution());
        this.dataList = (ArrayList)distributionLikelihood.getDataList();
        this.low = parameter;
        this.high = parameter2;
    }

    @Override
    protected double getLogPDF(double d, int n) {
        if (this.high.getParameterValue(n % this.high.getDimension()) == this.low.getParameterValue(n % this.low.getDimension())) {
            return 0.0;
        }
        if (d > this.low.getParameterValue(n % this.low.getDimension()) && d < this.high.getParameterValue(n % this.high.getDimension())) {
            double d2 = this.getDistribution().logPdf(d);
            double d3 = 0.0;
            if (!Double.isInfinite(this.low.getParameterValue(n % this.low.getDimension()))) {
                d3 = this.getDistribution().cdf(this.low.getParameterValue(n % this.low.getDimension()));
            }
            double d4 = 0.0;
            if (!Double.isInfinite(this.high.getParameterValue(n % this.high.getDimension()))) {
                d4 = 1.0 - this.getDistribution().cdf(this.high.getParameterValue(n % this.high.getDimension()));
            }
            return d2 - Math.log(1.0 - (d4 + d3));
        }
        return Double.NEGATIVE_INFINITY;
    }
}

