/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.continuous;

import dr.evolution.tree.MutableTreeModel;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.util.Taxon;
import dr.evolution.util.TaxonList;
import dr.evomodel.branchratemodel.BranchRateModel;
import dr.evomodel.continuous.MultivariateDiffusionModel;
import dr.evomodel.treedatalikelihood.BufferIndexHelper;
import dr.evomodel.treedatalikelihood.DataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.PreOrderSettings;
import dr.evomodel.treedatalikelihood.ProcessOnTreeDelegate;
import dr.evomodel.treedatalikelihood.ProcessSimulation;
import dr.evomodel.treedatalikelihood.RateRescalingScheme;
import dr.evomodel.treedatalikelihood.TreeDataLikelihood;
import dr.evomodel.treedatalikelihood.TreeTraversal;
import dr.evomodel.treedatalikelihood.continuous.ConditionalTraitSimulationHelper;
import dr.evomodel.treedatalikelihood.continuous.ConjugateRootTraitPrior;
import dr.evomodel.treedatalikelihood.continuous.ContinuousRateTransformation;
import dr.evomodel.treedatalikelihood.continuous.ContinuousTraitDataModel;
import dr.evomodel.treedatalikelihood.continuous.ContinuousTraitPartialsProvider;
import dr.evomodel.treedatalikelihood.continuous.DiffusionProcessDelegate;
import dr.evomodel.treedatalikelihood.continuous.DriftDiffusionModelDelegate;
import dr.evomodel.treedatalikelihood.continuous.IntegratedOUDiffusionModelDelegate;
import dr.evomodel.treedatalikelihood.continuous.MultivariateTraitDebugUtilities;
import dr.evomodel.treedatalikelihood.continuous.OUDiffusionModelDelegate;
import dr.evomodel.treedatalikelihood.continuous.RepeatedMeasuresTraitDataModel;
import dr.evomodel.treedatalikelihood.continuous.RootProcessDelegate;
import dr.evomodel.treedatalikelihood.continuous.cdi.ContinuousDiffusionIntegrator;
import dr.evomodel.treedatalikelihood.continuous.cdi.MultivariateIntegrator;
import dr.evomodel.treedatalikelihood.continuous.cdi.PrecisionType;
import dr.evomodel.treedatalikelihood.continuous.cdi.SafeMultivariateActualizedWithDriftIntegrator;
import dr.evomodel.treedatalikelihood.continuous.cdi.SafeMultivariateDiagonalActualizedWithDriftIntegrator;
import dr.evomodel.treedatalikelihood.continuous.cdi.SafeMultivariateIntegrator;
import dr.evomodel.treedatalikelihood.continuous.cdi.SafeMultivariateWithDriftIntegrator;
import dr.evomodel.treedatalikelihood.preorder.BranchConditionalDistributionDelegate;
import dr.evomodel.treedatalikelihood.preorder.ConditionalVarianceAndTransform;
import dr.evomodel.treedatalikelihood.preorder.NewTipFullConditionalDistributionDelegate;
import dr.evomodel.treedatalikelihood.preorder.TipFullConditionalDistributionDelegate;
import dr.evomodel.treedatalikelihood.preorder.TipGradientViaFullConditionalDelegate;
import dr.evomodel.treedatalikelihood.preorder.WrappedTipFullConditionalDistributionDelegate;
import dr.evomodel.treelikelihood.PartialsRescalingScheme;
import dr.inference.model.AbstractModel;
import dr.inference.model.MatrixParameterInterface;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.KroneckerOperation;
import dr.math.distributions.MultivariateNormalDistribution;
import dr.math.distributions.WishartSufficientStatistics;
import dr.math.interfaces.ConjugateWishartStatisticsProvider;
import dr.math.matrixAlgebra.Matrix;
import dr.math.matrixAlgebra.Vector;
import dr.math.matrixAlgebra.WrappedMatrix;
import dr.util.Citable;
import dr.util.Citation;
import dr.util.CommonCitations;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.logging.Logger;

public class ContinuousDataLikelihoodDelegate
extends AbstractModel
implements DataLikelihoodDelegate,
ConjugateWishartStatisticsProvider,
Citable {
    private final int numTraits;
    private final int dimTrait;
    private final int dimProcess;
    private final PrecisionType precisionType;
    private final ContinuousRateTransformation rateTransformation;
    private final Tree tree;
    private final BranchRateModel rateModel;
    private final ConjugateRootTraitPrior rootPrior;
    private final boolean forceCompletelyObserved;
    private double branchNormalization;
    private double storedBranchNormalization;
    private boolean allowSingular = false;
    private TreeDataLikelihood callbackLikelihood = null;
    private ConditionalTraitSimulationHelper extensionHelper = null;
    private final int tipCount;
    private final int[] branchUpdateIndices;
    private final double[] branchLengths;
    private final int[] operations;
    private boolean flip = true;
    private final BufferIndexHelper partialBufferHelper;
    private final DiffusionProcessDelegate diffusionProcessDelegate;
    private final RootProcessDelegate rootProcessDelegate;
    private final ContinuousTraitPartialsProvider dataModel;
    private final ContinuousDiffusionIntegrator cdi;
    private boolean updateDiffusionModel;
    private final Deque<Integer> updateTipData = new ArrayDeque<Integer>();
    private WishartSufficientStatistics wishartStatistics = null;
    private boolean computeWishartStatistics = false;
    private boolean computeRemainders = true;

    public ContinuousDataLikelihoodDelegate(Tree tree, DiffusionProcessDelegate diffusionProcessDelegate, ContinuousTraitPartialsProvider continuousTraitPartialsProvider, ConjugateRootTraitPrior conjugateRootTraitPrior, ContinuousRateTransformation continuousRateTransformation, BranchRateModel branchRateModel, boolean bl) {
        this(tree, diffusionProcessDelegate, continuousTraitPartialsProvider, conjugateRootTraitPrior, continuousRateTransformation, branchRateModel, false, bl);
    }

    public ContinuousDataLikelihoodDelegate(Tree tree, DiffusionProcessDelegate diffusionProcessDelegate, ContinuousTraitPartialsProvider continuousTraitPartialsProvider, ConjugateRootTraitPrior conjugateRootTraitPrior, ContinuousRateTransformation continuousRateTransformation, BranchRateModel branchRateModel, boolean bl, boolean bl2) {
        super("ContinuousDataLikelihoodDelegate");
        Logger logger = Logger.getLogger("dr.evomodel.treedatalikelihood");
        logger.info("Using ContinuousDataLikelihood Delegate");
        this.diffusionProcessDelegate = diffusionProcessDelegate;
        this.addModel(diffusionProcessDelegate);
        this.dataModel = continuousTraitPartialsProvider;
        if (continuousTraitPartialsProvider instanceof Model) {
            this.addModel((Model)((Object)continuousTraitPartialsProvider));
        }
        if (branchRateModel != null) {
            this.addModel(branchRateModel);
        }
        this.numTraits = continuousTraitPartialsProvider.getTraitCount();
        this.dimTrait = continuousTraitPartialsProvider.getTraitDimension();
        this.precisionType = bl ? PrecisionType.SCALAR : continuousTraitPartialsProvider.getPrecisionType();
        this.rateTransformation = continuousRateTransformation;
        this.tree = tree;
        this.rateModel = branchRateModel;
        this.rootPrior = conjugateRootTraitPrior;
        this.forceCompletelyObserved = bl;
        this.allowSingular = bl2;
        int n = tree.getNodeCount();
        this.tipCount = tree.getExternalNodeCount();
        int n2 = n - this.tipCount;
        this.branchUpdateIndices = new int[n];
        this.branchLengths = new double[n];
        this.partialBufferHelper = new BufferIndexHelper(n, continuousTraitPartialsProvider.bufferTips() ? 0 : this.tipCount);
        int n3 = this.partialBufferHelper.getBufferCount();
        int n4 = diffusionProcessDelegate.getEigenBufferCount();
        this.rootProcessDelegate = new RootProcessDelegate.FullyConjugate(conjugateRootTraitPrior, this.precisionType, this.numTraits, n3, n4);
        this.addModel(this.rootProcessDelegate);
        n3 += this.rootProcessDelegate.getExtraPartialBufferCount();
        n4 += this.rootProcessDelegate.getExtraMatrixBufferCount();
        this.operations = new int[(n2 + this.rootProcessDelegate.getExtraPartialBufferCount()) * 5];
        try {
            ContinuousDiffusionIntegrator.Basic basic;
            if (this.precisionType == PrecisionType.SCALAR) {
                basic = new ContinuousDiffusionIntegrator.Basic(this.precisionType, this.numTraits, this.dimTrait, this.dimTrait, n3, n4);
            } else if (this.precisionType == PrecisionType.FULL) {
                if (diffusionProcessDelegate instanceof IntegratedOUDiffusionModelDelegate) {
                    assert (this.dimTrait % 2 == 0) : "dimTrait should be twice dimProcess.";
                    basic = new SafeMultivariateActualizedWithDriftIntegrator(this.precisionType, this.numTraits, this.dimTrait, this.dimTrait / 2, n3, n4, ((OUDiffusionModelDelegate)diffusionProcessDelegate).isSymmetric());
                } else {
                    basic = diffusionProcessDelegate instanceof OUDiffusionModelDelegate ? (((OUDiffusionModelDelegate)diffusionProcessDelegate).hasDiagonalActualization() ? new SafeMultivariateDiagonalActualizedWithDriftIntegrator(this.precisionType, this.numTraits, this.dimTrait, this.dimTrait, n3, n4) : new SafeMultivariateActualizedWithDriftIntegrator(this.precisionType, this.numTraits, this.dimTrait, this.dimTrait, n3, n4, ((OUDiffusionModelDelegate)diffusionProcessDelegate).isSymmetric())) : (diffusionProcessDelegate instanceof DriftDiffusionModelDelegate ? new SafeMultivariateWithDriftIntegrator(this.precisionType, this.numTraits, this.dimTrait, this.dimTrait, n3, n4) : (bl2 ? new SafeMultivariateIntegrator(this.precisionType, this.numTraits, this.dimTrait, this.dimTrait, n3, n4) : new MultivariateIntegrator(this.precisionType, this.numTraits, this.dimTrait, this.dimTrait, n3, n4)));
                }
            } else {
                throw new RuntimeException("Not yet implemented");
            }
            this.cdi = basic;
            System.err.println("Base CDI is " + this.cdi.getClass().getCanonicalName());
            this.dimProcess = this.cdi.getDimProcess();
            for (int i = 0; i < this.tipCount; ++i) {
                NodeRef nodeRef = tree.getExternalNode(i);
                int n5 = nodeRef.getNumber();
                assert (i == n5);
                this.checkDataAlignment(nodeRef, tree);
            }
            this.setAllTipData(continuousTraitPartialsProvider.bufferTips());
            this.updateDiffusionModel = true;
        }
        catch (TaxonList.MissingTaxonException missingTaxonException) {
            throw new RuntimeException(missingTaxonException.toString());
        }
    }

    public TreeDataLikelihood getCallbackLikelihood() {
        return this.callbackLikelihood;
    }

    public ConditionalTraitSimulationHelper getExtensionHelper() {
        return this.extensionHelper;
    }

    public PrecisionType getPrecisionType() {
        return this.precisionType;
    }

    public ContinuousTraitPartialsProvider getDataModel() {
        return this.dataModel;
    }

    public RootProcessDelegate getRootProcessDelegate() {
        return this.rootProcessDelegate;
    }

    public ConjugateRootTraitPrior getRootPrior() {
        return this.rootPrior;
    }

    public int getPartialBufferCount() {
        return this.partialBufferHelper.getBufferCount();
    }

    public double[][] getTreeVariance() {
        double d = this.rateTransformation.getNormalization();
        double d2 = this.rootProcessDelegate.getPseudoObservations();
        return MultivariateTraitDebugUtilities.getTreeVariance(this.tree, this.callbackLikelihood.getBranchRateModel(), d, d2);
    }

    public double[][] getTreePrecision() {
        Matrix matrix = new Matrix(this.getTreeVariance()).inverse();
        return matrix.toComponents();
    }

    public double[][] getTraitVariance() {
        Matrix matrix = new Matrix(this.getDiffusionModel().getPrecisionmatrix()).inverse();
        return matrix.toComponents();
    }

    public double[][] getTreeTraitPrecision() {
        return KroneckerOperation.product(this.getTreePrecision(), this.getDiffusionModel().getPrecisionmatrix());
    }

    public double[][] getTreeTraitVariance() {
        return KroneckerOperation.product(this.getTreeVariance(), this.getTraitVariance());
    }

    @Override
    public String getReport() {
        Object object;
        Object object2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Tree:\n");
        stringBuilder.append(this.callbackLikelihood.getId()).append("\t");
        stringBuilder.append(this.cdi.getReport());
        Tree tree = this.callbackLikelihood.getTree();
        stringBuilder.append(tree.toString());
        stringBuilder.append("\n\n");
        double d = this.rateTransformation.getNormalization();
        double d2 = this.rootProcessDelegate.getPseudoObservations();
        double[][] dArray = MultivariateTraitDebugUtilities.getTreeVariance(tree, this.callbackLikelihood.getBranchRateModel(), 1.0, Double.POSITIVE_INFINITY);
        stringBuilder.append("Tree structure:\n");
        stringBuilder.append(new Matrix(dArray));
        stringBuilder.append("\n\n");
        double[][] dArray2 = MultivariateTraitDebugUtilities.getTreeVariance(tree, this.callbackLikelihood.getBranchRateModel(), this.rateTransformation.getNormalization(), Double.POSITIVE_INFINITY);
        double[][] dArray3 = this.getTreeVariance();
        double[][] dArray4 = this.getDiffusionModel().getPrecisionmatrix();
        Matrix matrix = new Matrix(dArray4).inverse();
        double[][] dArray5 = this.diffusionProcessDelegate.getJointVariance(d2, dArray3, dArray2, matrix.toComponents());
        if (this.dataModel instanceof RepeatedMeasuresTraitDataModel) {
            if (this.dimTrait == 1 && this.precisionType == PrecisionType.SCALAR) {
                double d3 = ((RepeatedMeasuresTraitDataModel)this.dataModel).getSamplingVariance().component(0, 0);
                int n = 0;
                while (n < this.tipCount) {
                    double[] dArray6 = dArray5[n];
                    int n2 = n++;
                    dArray6[n2] = dArray6[n2] + d3;
                }
            } else {
                for (int i = 0; i < this.tipCount; ++i) {
                    object2 = this.dataModel.getTipPartial(i, false);
                    WrappedMatrix.Raw raw = new WrappedMatrix.Raw((double[])object2, this.dimTrait + this.dimTrait * this.dimTrait, this.dimTrait, this.dimTrait);
                    for (int j = 0; j < this.dimTrait; ++j) {
                        for (int k = 0; k < this.dimTrait; ++k) {
                            double[] dArray7 = dArray5[i * this.dimTrait + j];
                            int n = i * this.dimTrait + k;
                            dArray7[n] = dArray7[n] + raw.get(j, k);
                        }
                    }
                }
            }
        }
        Matrix matrix2 = new Matrix(dArray3);
        object2 = matrix2.inverse();
        stringBuilder.append("Tree variance:\n");
        stringBuilder.append(matrix2);
        stringBuilder.append("Tree precision:\n");
        stringBuilder.append(object2);
        stringBuilder.append("\n\n");
        stringBuilder.append("Trait variance:\n");
        stringBuilder.append(matrix);
        stringBuilder.append("\n\n");
        stringBuilder.append("Joint variance:\n");
        stringBuilder.append(new Matrix(dArray5));
        stringBuilder.append("\n\n");
        double[] dArray8 = this.rootPrior.getMean();
        stringBuilder.append("prior mean: ").append(new Vector(dArray8));
        stringBuilder.append("\n\n");
        stringBuilder.append("Joint variance:\n");
        stringBuilder.append(new Matrix(dArray5));
        stringBuilder.append("\n\n");
        stringBuilder.append("Joint precision:\n");
        stringBuilder.append(new Matrix(this.getTreeTraitPrecision()));
        stringBuilder.append("\n\n");
        double[][] dArray9 = MultivariateTraitDebugUtilities.getTreeDrift(tree, dArray8, this.cdi, this.diffusionProcessDelegate);
        if (this.diffusionProcessDelegate.hasDrift()) {
            stringBuilder.append("Tree drift (including root mean):\n");
            stringBuilder.append(new Matrix(dArray9));
            stringBuilder.append("\n\n");
        }
        double[] dArray10 = KroneckerOperation.vectorize(dArray9);
        int n = this.tipCount * this.dimProcess;
        stringBuilder.append("Tree dim : ").append(dArray.length).append("\n");
        stringBuilder.append("dimTrait : ").append(this.dimTrait).append("\n");
        stringBuilder.append("numTraits: ").append(this.numTraits).append("\n");
        stringBuilder.append("jVar dim : ").append(dArray5.length).append("\n");
        stringBuilder.append("datum dim: ").append(n);
        stringBuilder.append("\n\n");
        double[] dArray11 = this.dataModel.getParameter().getParameterValues();
        if (this.dataModel instanceof ContinuousTraitDataModel) {
            for (int i = 0; i < this.tipCount; ++i) {
                object = ((ContinuousTraitDataModel)this.dataModel).getTipObservation(i, this.precisionType);
                System.arraycopy(object, 0, dArray11, i * this.numTraits * this.dimProcess, this.numTraits * this.dimProcess);
            }
        }
        stringBuilder.append("data: ").append(new Vector(dArray11));
        stringBuilder.append("\n\n");
        double[][] dArray12 = MultivariateTraitDebugUtilities.getGraphVariance(tree, this.callbackLikelihood.getBranchRateModel(), d, d2);
        object = KroneckerOperation.product(dArray12, matrix.toComponents());
        stringBuilder.append("graph structure:\n");
        stringBuilder.append(new Matrix(dArray12));
        stringBuilder.append("\n\n");
        for (int i = 0; i < this.numTraits; ++i) {
            int n3;
            stringBuilder.append("Trait #").append(i).append("\n");
            double[] dArray13 = new double[n];
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            int n4 = 0;
            for (int j = 0; j < this.tipCount; ++j) {
                for (int k = 0; k < this.dimProcess; ++k) {
                    double d4;
                    dArray13[n4] = d4 = dArray11[j * this.dimProcess * this.numTraits + i * this.dimProcess + k];
                    if (Double.isNaN(d4)) {
                        arrayList.add(n4);
                    }
                    ++n4;
                }
            }
            double[][] dArray14 = dArray5;
            double[] dArray15 = dArray13;
            double[] dArray16 = dArray10;
            int[] nArray = new int[n - arrayList.size()];
            int n5 = 0;
            for (int j = 0; j < n; ++j) {
                if (arrayList.contains(j)) continue;
                nArray[n5] = j;
                ++n5;
            }
            dArray15 = Matrix.gatherEntries(dArray13, nArray);
            dArray14 = Matrix.gatherRowsAndColumns(dArray5, nArray, nArray);
            dArray16 = Matrix.gatherEntries(dArray10, nArray);
            stringBuilder.append("datum : ").append(new Vector(dArray15)).append("\n");
            stringBuilder.append("drift : ").append(new Vector(dArray16)).append("\n");
            stringBuilder.append("variance:\n");
            stringBuilder.append(new Matrix(dArray14));
            MultivariateNormalDistribution multivariateNormalDistribution = new MultivariateNormalDistribution(dArray16, new Matrix(dArray14).inverse().toComponents());
            double d5 = multivariateNormalDistribution.logPdf(dArray15);
            stringBuilder.append("\n\n");
            stringBuilder.append("logDatumLikelihood: ").append(d5).append("\n\n");
            int[] nArray2 = new int[this.dimProcess * this.tipCount];
            int[] nArray3 = new int[this.dimProcess * (this.tipCount - 1)];
            for (n3 = 0; n3 < this.dimProcess * this.tipCount; ++n3) {
                nArray2[n3] = n3;
            }
            for (n3 = this.dimProcess * this.tipCount; n3 < this.dimProcess * (2 * this.tipCount - 1); ++n3) {
                nArray3[n3 - this.dimProcess * this.tipCount] = n3;
            }
            double[] dArray17 = new double[this.dimProcess * (2 * this.tipCount - 1)];
            System.arraycopy(dArray13, 0, dArray17, 0, dArray13.length);
            double[][] dArray18 = MultivariateTraitDebugUtilities.getGraphDrift(tree, this.cdi, this.diffusionProcessDelegate);
            double[] dArray19 = KroneckerOperation.vectorize(dArray18);
            for (int j = 0; j < dArray19.length / this.dimProcess; ++j) {
                for (int k = 0; k < this.dimProcess; ++k) {
                    int n6 = j * this.dimProcess + k;
                    dArray19[n6] = dArray19[n6] + dArray8[k];
                }
            }
            ConditionalVarianceAndTransform conditionalVarianceAndTransform = new ConditionalVarianceAndTransform(new Matrix((double[][])object), nArray3, nArray2);
            double[] dArray20 = conditionalVarianceAndTransform.getConditionalMean(dArray17, 0, dArray19, 0);
            stringBuilder.append("cDriftJoint: ").append(new Vector(dArray19)).append("\n\n");
            stringBuilder.append("cMeanInternalJoint: ").append(new Vector(dArray20)).append("\n\n");
            stringBuilder.append("Full conditional distributions:\n");
            int n7 = 0;
            for (int j = 0; j < this.tipCount; ++j) {
                int n8;
                int n9 = j * this.dimProcess;
                int n10 = 0;
                for (int k = 0; k < this.dimProcess; ++k) {
                    if (n7 + k >= nArray.length || nArray[n7 + k] >= n9 + this.dimProcess) continue;
                    ++n10;
                }
                int[] nArray4 = new int[this.dimProcess];
                int[] nArray5 = new int[nArray.length - n10];
                for (n8 = 0; n8 < this.dimProcess; ++n8) {
                    nArray4[n8] = n9 + n8;
                }
                for (n8 = 0; n8 < n7; ++n8) {
                    nArray5[n8] = nArray[n8];
                }
                for (n8 = n7 += n10; n8 < nArray.length; ++n8) {
                    nArray5[n8 - n10] = nArray[n8];
                }
                ConditionalVarianceAndTransform conditionalVarianceAndTransform2 = new ConditionalVarianceAndTransform(new Matrix(dArray5), nArray4, nArray5);
                double[] dArray21 = conditionalVarianceAndTransform2.getConditionalMean(dArray13, 0, dArray10, 0);
                Matrix matrix3 = conditionalVarianceAndTransform2.getConditionalVariance();
                stringBuilder.append("cMean #").append(j).append(" ").append(new Vector(dArray21)).append("\ncVar [").append(matrix3).append("]\n\n");
            }
        }
        return stringBuilder.toString();
    }

    private int[] getMissingTip(int n, int[] nArray, int n2) {
        int n3 = n * this.dimTrait;
        int n4 = 0;
        for (int i = 0; i < this.dimTrait; ++i) {
            if (nArray[n2 + i] >= n3 + this.dimTrait) continue;
            ++n4;
        }
        int[] nArray2 = new int[n4];
        for (int i = 0; i < n4; ++i) {
            nArray2[i] = nArray[n2 + i];
        }
        n2 += this.dimTrait;
        return nArray2;
    }

    @Override
    public final int getTraitCount() {
        return this.numTraits;
    }

    @Override
    public final int getTraitDim() {
        return this.dimTrait;
    }

    @Override
    public RateRescalingScheme getRateRescalingScheme() {
        return this.rateTransformation.getRateRescalingScheme();
    }

    public final ContinuousDiffusionIntegrator getIntegrator() {
        return this.cdi;
    }

    final ContinuousRateTransformation getRateTransformation() {
        return this.rateTransformation;
    }

    public final double getRateTransformationNormalization() {
        return this.rateTransformation.getNormalization();
    }

    @Override
    public void setCallback(TreeDataLikelihood treeDataLikelihood) {
        this.callbackLikelihood = treeDataLikelihood;
    }

    public void setExtensionHelper() {
        this.extensionHelper = new ConditionalTraitSimulationHelper(this.callbackLikelihood);
    }

    @Override
    public void setComputePostOrderStatisticsOnly(boolean bl) {
        this.computeRemainders = !bl;
    }

    @Override
    public boolean providesPostOrderStatisticsOnly() {
        return this.cdi instanceof ContinuousDiffusionIntegrator.Basic;
    }

    @Override
    public int vectorizeNodeOperations(List<ProcessOnTreeDelegate.NodeOperation> list, int[] nArray) {
        int n = 0;
        for (ProcessOnTreeDelegate.NodeOperation nodeOperation : list) {
            nArray[n] = this.getActiveNodeIndex(nodeOperation.getNodeNumber());
            nArray[n + 1] = this.getActiveNodeIndex(nodeOperation.getLeftChild());
            nArray[n + 2] = this.getActiveMatrixIndex(nodeOperation.getLeftChild());
            nArray[n + 3] = this.getActiveNodeIndex(nodeOperation.getRightChild());
            nArray[n + 4] = this.getActiveMatrixIndex(nodeOperation.getRightChild());
            n += 5;
        }
        return list.size();
    }

    public DiffusionProcessDelegate getDiffusionProcessDelegate() {
        return this.diffusionProcessDelegate;
    }

    public MultivariateDiffusionModel getDiffusionModel() {
        return this.diffusionProcessDelegate.getDiffusionModel(0);
    }

    private void setAllTipData(boolean bl) {
        for (int i = 0; i < this.tipCount; ++i) {
            this.setTipData(i, bl);
        }
        this.updateTipData.clear();
    }

    private void setTipData(int n, boolean bl) {
        if (bl) {
            this.partialBufferHelper.flipOffset(n);
        }
        double[] dArray = this.dataModel.getTipPartial(n, this.forceCompletelyObserved);
        this.setTipDataDirectly(n, dArray);
    }

    void setTipDataDirectly(int n, double[] dArray) {
        this.cdi.setPostOrderPartial(this.partialBufferHelper.getOffsetIndex(n), dArray);
    }

    private void checkDataAlignment(NodeRef nodeRef, Tree tree) throws TaxonList.MissingTaxonException {
        Taxon taxon;
        String string;
        boolean bl;
        int n = nodeRef.getNumber();
        Parameter parameter = this.dataModel.getParameter().getParameter(n);
        if (parameter != null && !(bl = (string = parameter.getParameterName()).contains((taxon = tree.getNodeTaxon(nodeRef)).getId()))) {
            throw new TaxonList.MissingTaxonException("Parameter name '" + string + "' does not contain taxon name '" + taxon.getId() + "'");
        }
    }

    @Override
    public TreeTraversal.TraversalType getOptimalTraversalType() {
        return TreeTraversal.TraversalType.POST_ORDER;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double calculateLikelihood(List<ProcessOnTreeDelegate.BranchOperation> list, List<ProcessOnTreeDelegate.NodeOperation> list2, int n) {
        this.branchNormalization = this.rateTransformation.getNormalization();
        int n2 = 0;
        for (ProcessOnTreeDelegate.BranchOperation object2 : list) {
            this.branchUpdateIndices[n2] = object2.getBranchNumber();
            this.branchLengths[n2] = object2.getBranchLength() * this.branchNormalization;
            ++n2;
        }
        if (!this.updateTipData.isEmpty()) {
            if (this.updateTipData.getFirst() == -1) {
                this.setAllTipData(this.flip);
            } else {
                while (!this.updateTipData.isEmpty()) {
                    int n3 = this.updateTipData.removeFirst();
                    this.setTipData(n3, this.flip);
                }
            }
        }
        if (this.updateDiffusionModel) {
            this.diffusionProcessDelegate.setDiffusionModels(this.cdi, this.flip);
            this.updateDiffusionModel = false;
        }
        if (n2 > 0) {
            this.diffusionProcessDelegate.updateDiffusionMatrices(this.cdi, this.branchUpdateIndices, this.branchLengths, n2, this.flip);
        }
        if (this.flip) {
            for (ProcessOnTreeDelegate.NodeOperation nodeOperation : list2) {
                this.partialBufferHelper.flipOffset(nodeOperation.getNodeNumber());
            }
        }
        int n4 = this.vectorizeNodeOperations(list2, this.operations);
        Object var6_11 = null;
        double[] dArray = null;
        if (this.computeWishartStatistics) {
            int[] nArray = new int[this.numTraits];
            dArray = new double[this.dimTrait * this.dimTrait * this.numTraits];
            this.cdi.setWishartStatistics(nArray, dArray);
        }
        this.cdi.updatePostOrderPartials(this.operations, n4, this.getActivePrecisionIndex(0), this.computeRemainders, this.computeWishartStatistics);
        double[] dArray2 = new double[this.numTraits];
        this.rootProcessDelegate.calculateRootLogLikelihood(this.cdi, this.partialBufferHelper.getOffsetIndex(n), this.getActivePrecisionIndex(0), dArray2, this.computeWishartStatistics, this.diffusionProcessDelegate.isIntegratedProcess());
        if (this.computeWishartStatistics) {
            void var6_13;
            this.cdi.getWishartStatistics((int[])var6_13, dArray);
            this.wishartStatistics = new WishartSufficientStatistics((int[])var6_13, dArray);
        } else {
            this.wishartStatistics = null;
        }
        double d = 0.0;
        for (double d2 : dArray2) {
            d += d2;
        }
        return d;
    }

    @Override
    public int getPartitionCat() {
        return 0;
    }

    @Override
    public double[] getSiteLogLikelihoods() {
        throw new RuntimeException("getSiteLogLikelihoods() not implemented");
    }

    public final int getActiveNodeIndex(int n) {
        return this.partialBufferHelper.getOffsetIndex(n);
    }

    public final int getActiveMatrixIndex(int n) {
        return this.diffusionProcessDelegate.getMatrixIndex(n);
    }

    public final int getActivePrecisionIndex(int n) {
        return this.diffusionProcessDelegate.getEigenBufferOffsetIndex(n);
    }

    public void getPostOrderPartial(int n, double[] dArray) {
        this.cdi.getPostOrderPartial(this.getActiveNodeIndex(n), dArray);
    }

    @Override
    public void makeDirty() {
        this.updateDiffusionModel = true;
        this.fireModelChanged();
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (model == this.diffusionProcessDelegate) {
            this.updateDiffusionModel = true;
            this.fireModelChanged();
        } else if (model == this.dataModel) {
            if (object == this.dataModel) {
                if (n == -1) {
                    this.updateTipData.addFirst(n);
                    this.fireModelChanged();
                } else {
                    this.updateTipData.addLast(n);
                    this.fireModelChanged(this, n);
                }
            }
        } else if (model instanceof BranchRateModel) {
            this.fireModelChanged();
        } else if (model == this.rootProcessDelegate) {
            this.fireModelChanged();
        } else {
            throw new RuntimeException("Unknown model component");
        }
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    public void storeState() {
        this.partialBufferHelper.storeState();
        this.flip = true;
        this.storedBranchNormalization = this.branchNormalization;
    }

    @Override
    public void restoreState() {
        this.partialBufferHelper.restoreState();
        this.branchNormalization = this.storedBranchNormalization;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public PreOrderSettings getPreOrderSettings() {
        return null;
    }

    @Override
    public boolean getPreferGPU() {
        return true;
    }

    @Override
    public boolean getUseAmbiguities() {
        return true;
    }

    @Override
    public PartialsRescalingScheme getRescalingScheme() {
        return null;
    }

    @Override
    public boolean getDelayRescalingUntilUnderflow() {
        return true;
    }

    @Override
    public long getTotalCalculationCount() {
        return 0L;
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.TRAIT_MODELS;
    }

    @Override
    public String getDescription() {
        return "Multivariate diffusion model (first citation) with efficiently integrated internal traits (second citation)";
    }

    @Override
    public List<Citation> getCitations() {
        ArrayList<Citation> arrayList = new ArrayList<Citation>();
        arrayList.add(CommonCitations.LEMEY_2010_PHYLOGEOGRAPHY);
        arrayList.add(CommonCitations.PYBUS_2012_UNIFYING);
        return arrayList;
    }

    @Override
    public WishartSufficientStatistics getWishartStatistics() {
        return this.wishartStatistics;
    }

    void setComputeWishartStatistics(boolean bl) {
        this.computeWishartStatistics = bl;
    }

    @Override
    public MatrixParameterInterface getPrecisionParameter() {
        return this.getDiffusionModel().getPrecisionParameter();
    }

    public void addFullConditionalGradientTrait(String string, int n, int n2) {
        TipGradientViaFullConditionalDelegate tipGradientViaFullConditionalDelegate = new TipGradientViaFullConditionalDelegate(string, (MutableTreeModel)this.getCallbackLikelihood().getTree(), this.getDiffusionModel(), this.getDataModel(), this.getRootPrior(), this.getRateTransformation(), this, n, n2);
        ProcessSimulation processSimulation = new ProcessSimulation(this.getCallbackLikelihood(), tipGradientViaFullConditionalDelegate);
        this.getCallbackLikelihood().addTraits(processSimulation.getTreeTraits());
    }

    public void addFullConditionalDensityTrait(String string) {
        TipFullConditionalDistributionDelegate tipFullConditionalDistributionDelegate = new TipFullConditionalDistributionDelegate(string, this.getCallbackLikelihood().getTree(), this.getDiffusionModel(), this.getDataModel(), this.getRootPrior(), this.getRateTransformation(), this);
        ProcessSimulation processSimulation = new ProcessSimulation(this.getCallbackLikelihood(), tipFullConditionalDistributionDelegate);
        this.getCallbackLikelihood().addTraits(processSimulation.getTreeTraits());
    }

    public void addNewFullConditionalDensityTrait(String string) {
        NewTipFullConditionalDistributionDelegate newTipFullConditionalDistributionDelegate = new NewTipFullConditionalDistributionDelegate(string, this.getCallbackLikelihood().getTree(), this.getDiffusionModel(), this.getDataModel(), this.getRootPrior(), this.getRateTransformation(), this);
        ProcessSimulation processSimulation = new ProcessSimulation(this.getCallbackLikelihood(), newTipFullConditionalDistributionDelegate);
        this.getCallbackLikelihood().addTraits(processSimulation.getTreeTraits());
    }

    public void addWrappedFullConditionalDensityTrait(String string) {
        WrappedTipFullConditionalDistributionDelegate wrappedTipFullConditionalDistributionDelegate = new WrappedTipFullConditionalDistributionDelegate(string, this.getCallbackLikelihood().getTree(), this.getDiffusionModel(), this.getDataModel(), this.getRootPrior(), this.getRateTransformation(), this);
        ProcessSimulation processSimulation = new ProcessSimulation(this.getCallbackLikelihood(), wrappedTipFullConditionalDistributionDelegate);
        this.getCallbackLikelihood().addTraits(processSimulation.getTreeTraits());
    }

    void addBranchConditionalDensityTrait(String string) {
        BranchConditionalDistributionDelegate branchConditionalDistributionDelegate = new BranchConditionalDistributionDelegate(string, this.getCallbackLikelihood().getTree(), this.getDiffusionModel(), this.getDataModel(), this.getRootPrior(), this.getRateTransformation(), this);
        ProcessSimulation processSimulation = new ProcessSimulation(this.getCallbackLikelihood(), branchConditionalDistributionDelegate);
        this.getCallbackLikelihood().addTraits(processSimulation.getTreeTraits());
    }

    static ContinuousDataLikelihoodDelegate createObservedDataOnly(ContinuousDataLikelihoodDelegate continuousDataLikelihoodDelegate, ContinuousTraitPartialsProvider continuousTraitPartialsProvider) {
        return new ContinuousDataLikelihoodDelegate(continuousDataLikelihoodDelegate.tree, continuousDataLikelihoodDelegate.diffusionProcessDelegate, continuousTraitPartialsProvider, continuousDataLikelihoodDelegate.rootPrior, continuousDataLikelihoodDelegate.rateTransformation, continuousDataLikelihoodDelegate.rateModel, true, false);
    }

    static ContinuousDataLikelihoodDelegate createWithMissingData(ContinuousDataLikelihoodDelegate continuousDataLikelihoodDelegate) {
        if (!(continuousDataLikelihoodDelegate.dataModel instanceof ContinuousTraitDataModel)) {
            throw new IllegalArgumentException("Not yet implemented");
        }
        List<Integer> list = ((ContinuousTraitDataModel)continuousDataLikelihoodDelegate.dataModel).getOriginalMissingIndices();
        if (list.size() == 0) {
            throw new IllegalArgumentException("ContinuousDataLikelihoodDelegate has no missing traits");
        }
        ContinuousTraitDataModel continuousTraitDataModel = new ContinuousTraitDataModel(((ContinuousTraitDataModel)continuousDataLikelihoodDelegate.dataModel).getName(), continuousDataLikelihoodDelegate.dataModel.getParameter(), ((ContinuousTraitDataModel)continuousDataLikelihoodDelegate.dataModel).getOriginalMissingIndicators(), true, continuousDataLikelihoodDelegate.getTraitDim(), PrecisionType.FULL);
        return new ContinuousDataLikelihoodDelegate(continuousDataLikelihoodDelegate.tree, continuousDataLikelihoodDelegate.diffusionProcessDelegate, continuousTraitDataModel, continuousDataLikelihoodDelegate.rootPrior, continuousDataLikelihoodDelegate.rateTransformation, continuousDataLikelihoodDelegate.rateModel, false, continuousDataLikelihoodDelegate.allowSingular);
    }

    public double[] getPostOrderRootMean() {
        PrecisionType precisionType = this.getDataModel().getPrecisionType();
        double[] dArray = new double[precisionType.getPartialsDimension(this.dimProcess)];
        this.getIntegrator().getPostOrderPartial(this.getActiveNodeIndex(this.tree.getRoot().getNumber()), dArray);
        double[] dArray2 = new double[this.dimProcess];
        System.arraycopy(dArray, precisionType.getMeanOffset(this.dimProcess), dArray2, 0, this.dimProcess);
        return dArray2;
    }
}

