/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.loggers.LogColumn;
import dr.inference.loggers.Loggable;
import dr.inference.loggers.NumberColumn;
import dr.inference.model.MatrixParameterInterface;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.Map;
import java.util.TreeMap;

public class LogOrderedMatrix
implements Loggable {
    private static final String ORDERED_MATRIX = "orderedMatrix";
    private static final String ORDER_BY = "orderBy";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(MatrixParameterInterface.class, 1, Integer.MAX_VALUE), AttributeRule.newStringRule("orderBy")};

        @Override
        public String getParserName() {
            return LogOrderedMatrix.ORDERED_MATRIX;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            MatrixParameterInterface matrixParameterInterface = (MatrixParameterInterface)xMLObject.getChild(MatrixParameterInterface.class);
            OrderBy orderBy = OrderBy.parseOrderBy(xMLObject);
            return new LogOrderedMatrix(matrixParameterInterface, orderBy);
        }

        @Override
        public String getParserDescription() {
            return "An ordered matrix logger.";
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public Class getReturnType() {
            return LogOrderedMatrix.class;
        }
    };
    private final MatrixParameterInterface matrix;
    private final OrderBy orderBy;
    private int[] orderMap;
    private static final boolean DEBUG = false;

    private LogOrderedMatrix(MatrixParameterInterface matrixParameterInterface, OrderBy orderBy) {
        this.matrix = matrixParameterInterface;
        this.orderBy = orderBy;
    }

    @Override
    public LogColumn[] getColumns() {
        LogColumn[] logColumnArray = new LogColumn[this.matrix.getRowDimension() * this.matrix.getColumnDimension()];
        int n = 0;
        for (int i = 0; i < this.matrix.getColumnDimension(); ++i) {
            for (int j = 0; j < this.matrix.getRowDimension(); ++j) {
                logColumnArray[n] = this.makeColumn(j, i);
                ++n;
            }
        }
        return logColumnArray;
    }

    private NumberColumn makeColumn(final int n, final int n2) {
        return new NumberColumn(this.getName(n, n2)){

            @Override
            public double getDoubleValue() {
                if (n == 0 && n2 == 0) {
                    LogOrderedMatrix.this.reorderMatrix();
                }
                return LogOrderedMatrix.this.matrix.getParameterValue(LogOrderedMatrix.this.orderBy.getRow(LogOrderedMatrix.this.orderMap, n), LogOrderedMatrix.this.orderBy.getCol(LogOrderedMatrix.this.orderMap, n2));
            }
        };
    }

    private void reorderMatrix() {
        int n;
        TreeMap<Double, Integer> treeMap = new TreeMap<Double, Integer>();
        for (n = 0; n < this.orderBy.getCount(this.matrix); ++n) {
            treeMap.put(-this.orderBy.getObjective(this.matrix, n), n);
        }
        this.orderMap = new int[treeMap.size()];
        n = 0;
        for (Map.Entry entry : treeMap.entrySet()) {
            this.orderMap[n] = (Integer)entry.getValue();
            ++n;
        }
    }

    private String getName(int n, int n2) {
        return "ordered." + this.matrix.getParameterName() + "." + (n2 + 1) + "." + (n + 1);
    }

    static enum OrderBy {
        COLUMN{

            @Override
            int getRow(int[] nArray, int n) {
                return n;
            }

            @Override
            int getCol(int[] nArray, int n) {
                return nArray[n];
            }

            @Override
            double getObjective(MatrixParameterInterface matrixParameterInterface, int n) {
                double d = 0.0;
                for (int i = 0; i < matrixParameterInterface.getRowDimension(); ++i) {
                    double d2 = matrixParameterInterface.getParameterValue(i, n);
                    d += d2 * d2;
                }
                return d;
            }

            @Override
            int getCount(MatrixParameterInterface matrixParameterInterface) {
                return matrixParameterInterface.getColumnDimension();
            }
        }
        ,
        ROW{

            @Override
            int getRow(int[] nArray, int n) {
                return nArray[n];
            }

            @Override
            int getCol(int[] nArray, int n) {
                return n;
            }

            @Override
            double getObjective(MatrixParameterInterface matrixParameterInterface, int n) {
                double d = 0.0;
                for (int i = 0; i < matrixParameterInterface.getColumnDimension(); ++i) {
                    double d2 = matrixParameterInterface.getParameterValue(n, i);
                    d += d2 * d2;
                }
                return d;
            }

            @Override
            int getCount(MatrixParameterInterface matrixParameterInterface) {
                return matrixParameterInterface.getRowDimension();
            }
        };


        abstract int getRow(int[] var1, int var2);

        abstract int getCol(int[] var1, int var2);

        abstract double getObjective(MatrixParameterInterface var1, int var2);

        abstract int getCount(MatrixParameterInterface var1);

        static OrderBy parseOrderBy(XMLObject xMLObject) throws XMLParseException {
            String string = xMLObject.getAttribute(LogOrderedMatrix.ORDER_BY, COLUMN.name());
            if (string.equalsIgnoreCase(COLUMN.name())) {
                return COLUMN;
            }
            if (string.equalsIgnoreCase(ROW.name())) {
                return ROW;
            }
            throw new XMLParseException("Unknown ordering");
        }
    }
}

