/*
 * Decompiled with CFR 0.152.
 */
package dr.geo;

import dr.app.gui.ColorFunction;
import dr.geo.AbstractPolygon2D;
import dr.geo.NumericalSpaceTimeProbs2D;
import dr.geo.Polygon2D;
import dr.geo.Reject;
import dr.geo.SpaceTime;
import dr.geo.SpaceTimeRejector;
import dr.math.distributions.MultivariateNormalDistribution;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class VisualizeKMLNumericalProbs
extends JComponent {
    List<AbstractPolygon2D> polygons;
    Point2D brussels = new Point2D.Double(4.35, 50.85);
    Point2D amsterdam = new Point2D.Double(4.89, 52.37);
    Point2D berlin = new Point2D.Double(13.41, 52.52);
    Point2D rome = new Point2D.Double(12.48, 41.9);
    Point2D naples = new Point2D.Double(14.283, 40.85);
    Point2D athens = new Point2D.Double(23.72, 37.98);
    Point2D paris = new Point2D.Double(2.35, 48.86);
    Point2D montepelier = new Point2D.Double(3.88, 43.61);
    Point2D munich = new Point2D.Double(11.58, 48.14);
    Point2D bern = new Point2D.Double(7.45, 46.95);
    Point2D start;
    Point2D end;
    Point2D topLeft;
    Point2D bottomRight;
    List<Shape> shapes;
    SpaceTimeRejector rejector;
    MultivariateNormalDistribution D;
    NumericalSpaceTimeProbs2D probs;
    ColorFunction cf;
    double scaleX;
    double scaleY;
    boolean ABSORBING = true;

    public VisualizeKMLNumericalProbs(String string) {
        this.polygons = Polygon2D.readKMLFile(string);
        System.out.println("Read " + this.polygons.size() + " polygons");
        this.start = this.bern;
        this.end = this.rome;
        this.topLeft = new Point2D.Double(-5.0, 28.0);
        this.bottomRight = new Point2D.Double(25.0, 57.0);
        System.out.println("Converting polygons to shapes");
        this.shapes = new ArrayList<Shape>();
        for (AbstractPolygon2D object2 : this.polygons) {
            this.shapes.add(object2.getShape());
            System.out.print(".");
            System.out.flush();
        }
        System.out.println();
        Rectangle2D.Double double_ = new Rectangle2D.Double(this.topLeft.getX(), this.topLeft.getY(), this.bottomRight.getX() - this.topLeft.getX(), this.bottomRight.getY() - this.topLeft.getY());
        final SpaceTimeRejector spaceTimeRejector = SpaceTimeRejector.Utils.createSimpleBounds2D(double_);
        this.rejector = new SpaceTimeRejector(){

            @Override
            public boolean reject(double d, double[] dArray) {
                if (spaceTimeRejector.reject(d, dArray)) {
                    return true;
                }
                double d2 = dArray[0];
                double d3 = dArray[1];
                for (Shape shape : VisualizeKMLNumericalProbs.this.shapes) {
                    if (!shape.contains(d2, d3)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void reset() {
            }

            @Override
            public List<Reject> getRejects() {
                return null;
            }
        };
        this.cf = new ColorFunction(new Color[]{Color.white, Color.blue, Color.magenta, Color.red}, new float[]{0.0f, 0.1f, 0.2f, 1.0f});
        this.D = new MultivariateNormalDistribution(new double[]{0.0}, new double[][]{{1.0, 0.0}, {0.0, 1.0}});
        if (this.rejector.reject(0.0, new double[]{this.start.getX(), this.start.getY()})) {
            throw new RuntimeException("The start position was rejected!");
        }
        this.probs = new NumericalSpaceTimeProbs2D(50, 50, 50, 50, 1.0, double_, this.D, this.rejector);
        System.out.println("Populating...");
        if (this.ABSORBING) {
            int n = this.probs.populateAbsorbing(this.start, 2000000);
            System.out.println(n + " paths simulated successfully simulated");
        } else {
            this.probs.populate(this.start, 25000, false);
        }
        System.out.println("Finished populating...");
    }

    void computeScales() {
        this.scaleX = (double)this.getWidth() / (this.bottomRight.getX() - this.topLeft.getX());
        this.scaleY = (double)this.getHeight() / (this.bottomRight.getY() - this.topLeft.getY());
    }

    @Override
    public void paintComponent(Graphics graphics) {
        System.out.println("entering paintComponent()");
        this.computeScales();
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setStroke(new BasicStroke(1.5f));
        int n = this.probs.x(this.start.getX());
        int n2 = this.probs.y(this.start.getY());
        int n3 = 49;
        double d = this.probs.maxCount[n][n2][n3];
        System.out.println("start max count = " + d);
        AffineTransform affineTransform = this.getFullTransform();
        System.out.println("Painting lattice probs");
        for (int i = 0; i < this.probs.latticeWidth; ++i) {
            for (int j = 0; j < this.probs.latticeHeight; ++j) {
                float f = (float)this.probs.r(n, n2, i, j, n3);
                Rectangle2D.Double double_ = new Rectangle2D.Double((double)i * this.probs.dx + this.probs.minx, (double)j * this.probs.dy + this.probs.miny, this.probs.dx, this.probs.dy);
                graphics.setColor(this.cf.getColor(f));
                graphics2D.fill(affineTransform.createTransformedShape(double_));
                graphics.setColor(Color.black);
                graphics2D.draw(affineTransform.createTransformedShape(double_));
            }
        }
        System.out.println("Painting shapes");
        for (Shape shape : this.shapes) {
            System.out.print(".");
            System.out.flush();
            GeneralPath generalPath = new GeneralPath(shape);
            generalPath.transform(affineTransform);
            graphics2D.setPaint(Color.BLACK);
            graphics2D.fill(generalPath);
        }
        graphics2D.setColor(Color.yellow);
        SpaceTime.paintDot(new SpaceTime(0.0, this.start), 4.0, affineTransform, graphics2D);
        graphics2D.setColor(Color.green);
        SpaceTime.paintDot(new SpaceTime(0.0, this.end), 4.0, affineTransform, graphics2D);
        int n4 = this.probs.x(this.end.getX());
        int n5 = this.probs.y(this.end.getY());
        String string = "p=" + this.probs.p(n, n2, n4, n5, n3) + " r=" + this.probs.r(n, n2, n4, n5, n3) + " c=" + this.probs.counts[n][n2][n4][n5][n3];
        graphics2D.setColor(Color.yellow);
        graphics2D.drawString(string, 20, this.getHeight() - 20);
    }

    AffineTransform getFullTransform() {
        AffineTransform affineTransform = this.getScale();
        affineTransform.concatenate(this.getTranslate());
        return affineTransform;
    }

    AffineTransform getTranslate() {
        return AffineTransform.getTranslateInstance(-this.topLeft.getX(), -this.bottomRight.getY());
    }

    AffineTransform getScale() {
        return AffineTransform.getScaleInstance(this.scaleX, -this.scaleY);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Europe");
        jFrame.getContentPane().add("Center", new VisualizeKMLNumericalProbs(stringArray[0]));
        jFrame.setSize(900, 900);
        jFrame.setVisible(true);
    }
}

