/*
 * Decompiled with CFR 0.152.
 */
package dr.geo;

import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.jdom.Element;

public class KMLCoordinates {
    public static final String COORDINATES = "coordinates";
    public static final String FORMAT = "%7.5f";
    public static final String SEPARATOR = ",";
    public static final String NEWLINE = "\n";
    public static final String POINT_SEPARATORS = "\n ";
    public static XMLObjectParser COORDINATESPARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(String.class)};

        @Override
        public String getParserName() {
            return KMLCoordinates.COORDINATES;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            String string = (String)xMLObject.getChild(0);
            StringTokenizer stringTokenizer = new StringTokenizer(string, KMLCoordinates.POINT_SEPARATORS);
            int n = stringTokenizer.countTokens();
            double[] dArray = new double[n];
            double[] dArray2 = new double[n];
            double[] dArray3 = new double[n];
            for (int i = 0; i < n; ++i) {
                String string2 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, KMLCoordinates.SEPARATOR);
                if (stringTokenizer2.countTokens() != 3) {
                    throw new XMLParseException("All KML coordinates must contain (X,Y,Z) values.  Three dimensions not found in element '" + string2 + "'");
                }
                dArray[i] = Double.valueOf(stringTokenizer2.nextToken());
                dArray2[i] = Double.valueOf(stringTokenizer2.nextToken());
                dArray3[i] = Double.valueOf(stringTokenizer2.nextToken());
            }
            return new KMLCoordinates(dArray, dArray2, dArray3);
        }

        @Override
        public String getParserDescription() {
            return "This element represents a set of (X,Y,Z) coordinates in KML format";
        }

        @Override
        public Class getReturnType() {
            return KMLCoordinates.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    public double[] x;
    public double[] y;
    public double[] z;
    public int length;

    public KMLCoordinates(double[] dArray, double[] dArray2) {
        this(dArray, dArray2, 0.0);
    }

    public KMLCoordinates(double[] dArray, double[] dArray2, double d) {
        this.x = dArray;
        this.y = dArray2;
        if (dArray.length != dArray2.length) {
            throw new RuntimeException("Cannot create coordinate system with unbalanced entries");
        }
        this.z = new double[dArray.length];
        Arrays.fill(this.z, d);
    }

    public KMLCoordinates(double[] dArray, double[] dArray2, double[] dArray3) {
        this.x = dArray;
        this.y = dArray2;
        this.z = dArray3;
        if (dArray.length != dArray2.length && dArray.length != dArray3.length) {
            throw new RuntimeException("Cannot create coordinate system with unbalanced entries");
        }
        this.length = dArray.length;
    }

    public void switchXY() {
        double[] dArray = this.x;
        this.x = this.y;
        this.y = dArray;
    }

    public Element toXML() {
        Element element = new Element(COORDINATES);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(POINT_SEPARATORS);
        for (int i = 0; i < this.x.length; ++i) {
            stringBuffer.append(String.format(FORMAT, this.x[i])).append(SEPARATOR);
            stringBuffer.append(String.format(FORMAT, this.y[i])).append(SEPARATOR);
            stringBuffer.append(String.format(FORMAT, this.z[i])).append(POINT_SEPARATORS);
        }
        element.addContent(stringBuffer.toString());
        return element;
    }
}

