% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulation_Based_Calibration.R
\name{Simulation_Based_Calibration_histogram}
\alias{Simulation_Based_Calibration_histogram}
\title{Draw a histogram of the rank statistics}
\usage{
Simulation_Based_Calibration_histogram(N = 3, sd = 5, C = 5,
  initial.seed.for.drawing.a.rank.statistics = 1234567,
  fun = stats::var, NI = 259, NL = 259,
  initial.seed.for.drawing.a.data = 1234, ModifiedPoisson = FALSE,
  ite = 1111, DrawCurve = FALSE)
}
\arguments{
\item{N}{samples size of the rank statistics.}

\item{sd}{Standard Deviation of priors}

\item{C}{No. of Confidence levels}

\item{initial.seed.for.drawing.a.rank.statistics}{seed}

\item{fun}{An one dimensional real valued function defined on the parameter space. This is used in the definition of the rank statistics. Generally speaking, the element of the parameter space is a vector, so the function should be defined on vectors. In my model parameter is mean, standard deviation, C thresholds of the latent Gaussian, so this function should be defined on the C+2 dimensional Euclidean space.}

\item{NI}{No. of images}

\item{NL}{No. of Lesions}

\item{initial.seed.for.drawing.a.data}{seed}

\item{ModifiedPoisson}{Logical, that is \code{TRUE} or \code{FALSE}. If
\code{ModifiedPoisson = TRUE}, then Poisson rate of false alarm is \code{per lesion},
and if \code{ModifiedPoisson = FALSE}, then Poisson rate of false alarm is \code{per image}.
To know detail, refer the author's paper in which I explained per image and per lesion.(for details of models, see   \href{https://cran.r-project.org/package=BayesianFROC}{ vignettes  })

If \code{ModifiedPoisson = TRUE}, then False Positive Fraction (FPF) is calculated as follows
\deqn{ \frac{f_1+f_2+f_3+f_4+f_5}{N_L}, }

\deqn{ \frac{f_2+f_3+f_4+f_5}{N_L}, }

 \deqn{ \frac{f_3+f_4+f_5}{N_L}, }

  \deqn{ \frac{f_4+f_5}{N_L}, }

   \deqn{ \frac{f_5}{N_L}, }

where \eqn{N_L} is a number of lesions (signal).


On the other hand,


if \code{ModifiedPoisson = FALSE}(Default), then
\deqn{ \frac{f_1+f_2+f_3+f_4+f_5}{N_I}, }

\deqn{ \frac{f_2+f_3+f_4+f_5}{N_I}, }

 \deqn{ \frac{f_3+f_4+f_5}{N_I}, }

  \deqn{ \frac{f_4+f_5}{N_I}, }

   \deqn{ \frac{f_5}{N_I}, }

where \eqn{N_I} is a number of images (trial).


So,data of FPF and TPF are changed thus, a fitted model is also changed whether  \code{ModifiedPoisson = TRUE} or \code{FALSE}.
In traditional FROC analysis, it use only per trial. But, if we devide one image into two images or more images, number of
trial is not important. And more important is per signal. So, the author developed FROC theory to consider FROC analysis under per signal.


Revised 2019 6.19}

\item{ite}{To be passed to the function \code{rstan::}\code{\link[rstan]{sampling}}() in \strong{rstan}. An argument of \code{rstan::}\code{\link[rstan]{sampling}}()  in which it is named \code{iter}. A positive integer representing  the  number of samples generated by Hamiltonian Monte Carlo method,
and, default = 10000. If your model could not converge, then raise this number. Must be greater for more reliable estimates.}

\item{DrawCurve}{Logical: \code{TRUE} of \code{FALSE}. Whether the curve is to be drawn. TRUE or FALSE. If you want to draw the FROC and AFROC curves, then you set \code{DrawCurve =TRUE}, if not then \code{DrawCurve =FALSE}.
The reason why the author make this variable \code{DrawCurve} is that it takes long time in MRMC case to draw curves, and thus default value is \code{FALSE} in the case of MRMC data.}
}
\value{
samples of rank statistics
}
\description{
To validate that the MCMC procedure is correct or not, we show the  histogram of rank statistics. If the resulting histogram is uniformly distributed, then we can conclude that the MCMC sampling is correct. If the histogram is far from uniformity, then the MCMC sampling or specification of priors is not correct or not appropriate.
}
\examples{
\dontrun{
  g <-Simulation_Based_Calibration_histogram(N=2,ite = 2222)

  graphics::hist(g$rank.statistics)




  g <- Simulation_Based_Calibration_histogram(
  NI=1111111,
  NL=1111111,
  # N =100 would be better  more than N =10
  # But this is only example, we take very small N
  N=10,
  ite=3333,
  sd=1,
  initial.seed.for.drawing.a.rank.statistics = 123456789,
  DrawCurve = T
  )



   g <- Simulation_Based_Calibration_histogram(
   NI=1111111,
   NL=1111111,
  # N =100 would be better  more than N =10
  # But this is only example, we take very small N
   N=10,
   ite=3333,
   sd=1,initial.seed.for.drawing.a.rank.statistics = 123456789,
   DrawCurve = T,
   C=11)
#=======      The Second Example:       =================================================

# If you want to see the replicated data, then the following code is available.
# In the following, I extract the dataset which is very small rank statistics, e.g.
# less than 10. And draw the CFP and CTP for observation of dataset.




gggg <- Simulation_Based_Calibration_histogram(
NI=1111111,
NL=1111111,
N=22,
ite=2222)


 a <- gggg$rank.statistics<10

 aa <- the_row_number_of_logical_vector(a)


  draw.CFP.CTP.from.dataList(gggg$fit.list[[  aa[1]  ]]@dataList)


}#\dontrun
}
