% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bvs.R
\name{print.Bvs}
\alias{print.Bvs}
\title{Print an object of class \code{Bvs}}
\usage{
\method{print}{Bvs}(x, ...)
}
\arguments{
\item{x}{An object of class \code{Bvs}}

\item{...}{Additional parameters to be passed}
}
\description{
Print an object of class \code{Bvs}. The ten most probable models (among the visited ones if the object was created with
GibbsBvs) are shown jointly with their Bayes factors and an estimation of their posterior probability based on the estimation
of the normalizing constant.
}
\examples{

\dontrun{
#Analysis of Crime Data
#load data
data(UScrime)

#Default arguments are Robust prior for the regression parameters
#and constant prior over the model space
#Here we keep the 1000 most probable models a posteriori:
crime.Bvs<- Bvs(formula= y ~ ., data=UScrime, n.keep=1000)

#A look at the results:
print(crime.Bvs)
}

}
\seealso{
See \code{\link[BayesVarSel]{Bvs}},
  \code{\link[BayesVarSel]{GibbsBvs}} for creating objects of the class
  \code{Bvs}.
}
\author{
Gonzalo Garcia-Donato and Anabel Forte

  Maintainer: <anabel.forte@uv.es>
}
