% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BFr.R
\name{BFrlogOR}
\alias{BFrlogOR}
\title{Generalized replication Bayes factor for logOR effect sizes}
\usage{
BFrlogOR(
  ao,
  bo,
  nTo = ao + bo,
  co,
  do,
  nCo = co + do,
  ar,
  br,
  nTr = ar + br,
  cr,
  dr,
  nCr = cr + dr,
  ss,
  method = c("integration", "hypergeo")
)
}
\arguments{
\item{ao}{Number of cases in original study treatment group}

\item{bo}{Number of non-cases in original study treatment group}

\item{nTo}{Number of participants in original study treatment group (specify
alternatively to \code{b})}

\item{co}{Number of cases in original study control group}

\item{do}{Number of non-cases in original study control group}

\item{nCo}{Number of participants in original study control group (specify
alternatively to \code{d})}

\item{ar}{Number of cases in replication study treatment group}

\item{br}{Number of non-cases in replication study treatment group}

\item{nTr}{Number of participants in replication study treatment group
(specify alternatively to \code{b})}

\item{cr}{Number of cases in replication study control group}

\item{dr}{Number of non-cases in replication study control group}

\item{nCr}{Number of participants in replication study control group (specify
alternatively to \code{d})}

\item{ss}{Standard deviation of the sceptical prior under
\eqn{H_\mathrm{S}}{HS}. Defaults to \code{0}}

\item{method}{Method to compute posterior density. Either
\code{"integration"} (default) or \code{"hypergeo"}}
}
\value{
The generalized replication Bayes factor
\eqn{\mathrm{BF}_{\mathrm{SA}}}{BF_SA}. \eqn{\mathrm{BF}_{\mathrm{SA}} <
    1}{BF_SA < 1} indicates that the data favour the advocate's hypothesis
\eqn{H_{\mathrm{A}}}{HA} (replication success), whereas
\eqn{\mathrm{BF}_{\mathrm{SA}} > 1}{BF_SA > 1} indicates that the data
favour the sceptic's hypothesis \eqn{H_{\mathrm{S}}}{HS} (replication
failure).
}
\description{
Computes the generalized replication Bayes factor for log odds
ratio (logOR) effect sizes
}
\details{
This function computes the generalized replication Bayes factor for
log odds ratio (logOR) effect sizes using an exact binomial likelihood
for the data instead of the normal approximation used in
\code{\link{BFr}} (for details, see Section 4 in Pawel and Held, 2022).
}
\examples{
data("SSRPexact")
balafoutas2012 <- subset(SSRPexact, study == "Balafoutas and Sutter (2012), Science")
with(balafoutas2012,
     BFrlogOR(ao = ao, bo = bo, co = co, do = do, ar = ar, br = br, cr = cr, dr = dr,
              ss = 0))

}
\references{
Verhagen, J. and Wagenmakers, E. J. (2014). Bayesian tests to
quantify the result of a replication attempt. Journal of Experimental
Psychology: General, 145:1457-1475. \doi{10.1037/a0036731}

Pawel, S. and Held, L. (2022). The sceptical Bayes factor for the assessment
of replication success. Journal of the Royal Statistical Society Series
B: Statistical Methodology, 84(3): 879-911. \doi{10.1111/rssb.12491}
}
\author{
Samuel Pawel
}
