% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmcRocPrc.R
\name{mcmcRocPrc}
\alias{mcmcRocPrc}
\title{ROC and Precision-Recall Curves using Bayesian MCMC estimates}
\usage{
mcmcRocPrc(object, yname, xnames, curves, fullsims)
}
\arguments{
\item{object}{A "rjags" object (see \code{\link[R2jags]{jags}}) for a fitted binary
choice model.}

\item{yname}{(\code{character(1)})\cr
The name of the dependent variable, should match the variable name in the
JAGS data object.}

\item{xnames}{(\code{\link[base:character]{base::character()}})\cr
A character vector of the independent variable names, should match the
corresponding names in the JAGS data object.}

\item{curves}{logical indicator of whether or not to return values to plot
the ROC or Precision-Recall curves. If set to \code{FALSE} (default),
results are returned as a list without the extra values.}

\item{fullsims}{logical indicator of whether full object (based on all MCMC
draws rather than their average) will be returned. Default is \code{FALSE}.
Note: If \code{TRUE} is chosen, the function takes notably longer to execute.}
}
\value{
Returns a list; the specific structure depends on the combination
of the "curves" and "fullsims" argument values.
}
\description{
Generate ROC and Precision-Recall curves after fitting a Bayesian logit or
probit regression using \code{\link[R2jags]{jags}}
}
\examples{
\dontshow{.old_wd <- setwd(tempdir())}
\donttest{
# load simulated data and fitted model (see ?sim_data and ?jags_logit)
data("jags_logit")

# using mcmcRocPrc
fit_sum <- mcmcRocPrc(jags_logit,
                      yname = "Y",
                      xnames = c("X1", "X2"),
                      curves = TRUE,
                      fullsims = FALSE)
}

\dontshow{setwd(.old_wd)}
}
\references{
Beger, Andreas. 2016. “Precision-Recall Curves.” Available at
SSRN: \url{http://dx.doi.org/10.2139/ssrn.2765419}
}
