% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitted_blc.R
\name{fitted.BLC}
\alias{fitted.BLC}
\title{BLC: Fitted death probabilities (qx)}
\usage{
\method{fitted}{BLC}(object, prob = 0.95, ...)
}
\arguments{
\item{object}{A \code{BLC} or \code{PredBLC} object, result of a call to blc() or predict() function.}

\item{prob}{A real number that indicates the probability of the credible interval.}

\item{...}{Other arguments.}
}
\value{
A list with the matrices of fitted values and lower and upper limits of the credible interval for each age and year.
}
\description{
Computes the fitted values associated to each age and year based on
the resulting chains from a fitted BLC model. In addition, this function also
evaluates the values of lower and upper limits of the credible interval.
}
\examples{
## Importing log-mortality data from Portugal:
data(PT)
Y <- PT

## Fitting the model
fit = blc(Y = Y, M = 100, bn = 20)

## Log-mortalities estimates for each age and year in model fitted
fitted(fit, prob = 0.95)

}
\seealso{
\code{\link[=fitted.HP]{fitted.HP()}} and \code{\link[=fitted.DLM]{fitted.DLM()}} for \code{HP} or \code{DLM} methods.
}
