% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likelihoods.R
\name{likelihood.seqtoone_normal}
\alias{likelihood.seqtoone_normal}
\title{Use a Normal likelihood for a seq-to-one recurrent network}
\usage{
likelihood.seqtoone_normal(chain, sig_prior)
}
\arguments{
\item{chain}{Network structure obtained using \code{link{Chain}}}

\item{sig_prior}{A prior distribution for sigma defined using
\code{\link{Gamma}}, \code{link{InverGamma}},
\code{\link{Truncated}}, \code{\link{Normal}}}
}
\value{
see \code{\link{likelihood.feedforward_normal}}
}
\description{
This creates a likelihood of the form
\deqn{y_i \sim Normal(net(x_i), \sigma), i=1,...,N}
Here \eqn{x_i} is a subsequence which will be fed through the recurrent
network to obtain the final output \eqn{net(x_i) = \hat{y}_i}. Thus, if
one has a single time series, and splits the single time series into subsequences
of length K which are then used to predict the next output of the time series, then
each \eqn{x_i} consists of K consecutive observations of the time series. In a sense
one constraints the maximum memory length of the network this way.
}
\examples{
\dontrun{
  ## Needs previous call to `BayesFluxR_setup` which is time
  ## consuming and requires Julia and BayesFlux.jl
  BayesFluxR_setup(installJulia=TRUE, seed=123)
  net <- Chain(RNN(5, 1))
  like <- likelihood.seqtoone_normal(net, Gamma(2.0, 0.5))
  prior <- prior.gaussian(net, 0.5)
  init <- initialise.allsame(Normal(0, 0.5), like, prior)
  x <- array(rnorm(5*100*10), dim=c(10,5,100))
  y <- rnorm(100)
  bnn <- BNN(x, y, like, prior, init)
  BNN.totparams(bnn)
}

}
