% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PWECode.R
\name{genpwedata}
\alias{genpwedata}
\title{Generating function for Piece-wise Exponential Data.}
\usage{
genpwedata(sample_size, lambda_vec, hazard_ratio, time_vec, censor_value)
}
\arguments{
\item{sample_size}{Number of subjects per arm.}

\item{lambda_vec}{Set of lambdas passed to \code{eha::rpch()} through the
levels parameter.  Used only in control arm.}

\item{hazard_ratio}{Desired Hazard Ratio between experimental and control groups.}

\item{time_vec}{Set of cutpoints passed to \code{eha::rpch()} through the
cuts parameter.}

\item{censor_value}{Value at which time-to-event data are right censored.}
}
\value{
\code{genpwedata()} returns a data frame with columns: 'id', 'treatment',
  'event_time', 'status', and 'indicator'.
}
\description{
\code{genpwedata()} function used mainly internally by
\code{pwetrialsimulator()} function to generate data for a two-arm
clinical trial, experimental and control groups.  Can be used to generate
random trial data.
}
\examples{
nvalHC <- 60
time.vec <- c(0.3,0.9,1.5,2.1,2.4)
lambdaHC.vec <- c(0.19,0.35,0.56,0.47,0.38,0.34)
censor.value <- 3

SampleHistData <- genpwedata(nvalHC, lambdaHC.vec, 1.0, time.vec, censor.value)
SampleHistData
}
