% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Stuff.R
\name{plotSubCurve}
\alias{plotSubCurve}
\title{Plot substance curve for several simulations}
\usage{
plotSubCurve(
  simlist,
  mediac = NULL,
  time = c(NULL, NULL),
  scol = NULL,
  unit = "mmol",
  ret_data = FALSE,
  num_var = 10,
  useNames = FALSE
)
}
\arguments{
\item{simlist}{A list of simulations (eval objects).}

\item{mediac}{A vector of substances (if not specified most varying substances will be taken.)}

\item{time}{Vector with two entries defining start and end time.}

\item{scol}{Vector with colors that should be used.}

\item{unit}{Unit for the substances which should be used for plotting (default: mmol)}

\item{ret_data}{Set true if data should be returned}

\item{num_var}{Number of varying substances to be shown (if mediac is not specified)}

\item{useNames}{Use substance names instead of ids}
}
\value{
list of three ggplot object for further formating
}
\description{
The function \code{plotSubCurve} takes a list of simulations and plots the time course of substances with standard deviation.
}
