% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Arena.R
\docType{methods}
\name{checkPhen}
\alias{checkPhen}
\alias{checkPhen,Arena-method}
\title{Function for checking phenotypes in the environment}
\usage{
checkPhen(object, org, cutoff = 1e-06, fbasol)

\S4method{checkPhen}{Arena}(object, org, cutoff = 1e-06, fbasol)
}
\arguments{
\item{object}{An object of class Arena.}

\item{org}{An object of class Organism.}

\item{cutoff}{A number giving the cutoff for values of the objective function and fluxes of exchange reactions.}

\item{fbasol}{Problem object according to the constraints and then solved with \code{optimizeProb}.}
}
\value{
Returns a number indicating the number of the phenotype in the phenotype list.
}
\description{
The generic function \code{checkPhen} checks and adds the phenotypes of organisms in the environment.
}
\details{
The phenotypes are defined by flux through exchange reactions, which indicate potential differential substrate usages. Uptake of substances are indicated by a negative and production of substances by a positive number.
}
\seealso{
\code{\link{Arena-class}} and \code{\link{getPhenotype}}
}
