% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Arena.R
\docType{methods}
\name{stirEnv}
\alias{stirEnv}
\alias{stirEnv,Arena-method}
\title{Function for stirring/mixing the complete evironment}
\usage{
stirEnv(object, sublb)

\S4method{stirEnv}{Arena}(object, sublb)
}
\arguments{
\item{object}{An object of class Arena.}

\item{sublb}{A matrix with the substrate concentration for every individual in the environment based on their x and y position.}
}
\value{
Returns the substrate concentration for every individual in the environment with substrates as well as x and y positions as columns and rows for each organism.
}
\description{
The generic function \code{stirEnv} simulates the event of mixing all substrates and organisms in the environment.
}
\details{
The stirring is implemented as a random permutation of organism positions and the equalization of of all substrate concentrations.
}
\examples{
data(Ec_core, envir = environment()) #get Escherichia coli core metabolic model
bac <- Bac(Ec_core,deathrate=0.05,
           growthlimit=0.05,growtype="exponential") #initialize a bacterium
arena <- Arena(n=20,m=20) #initialize the environment
addOrg(arena,bac,amount=10) #add 10 organisms
addSubs(arena,40) #add all possible substances
sublb <- getSublb(arena)
stirEnv(arena,sublb)
}
\seealso{
\code{\link{Arena-class}} and \code{\link{getSublb}}
}

