% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/simulate.R
\docType{methods}
\name{simulate,mixedDiffusion-method}
\alias{simulate,mixedDiffusion-method}
\title{Simulation of hierarchical (mixed) diffusion model}
\usage{
\S4method{simulate}{mixedDiffusion}(object, nsim = 1, seed = NULL, t,
  mw = 1, plot.series = TRUE)
}
\arguments{
\item{object}{class object of parameters: "mixedDiffusion"}

\item{nsim}{number of data sets to simulate. Default is 1.}

\item{seed}{optional: seed number for random number generator}

\item{t}{vector of time points}

\item{mw}{mesh width for finer Euler approximation to simulate time-continuity}

\item{plot.series}{logical(1), if TRUE, simulated series are depicted grafically}
}
\description{
Simulation of the stochastic process model
  \eqn{dY_t = b(\phi_j,t,Y_t)dt + \gamma \widetilde{s}(t,Y_t)dW_t, \phi_j~N(\mu, \Omega)}.
}
\examples{
mu <- 2; Omega <- 0.4; phi <- matrix(rnorm(21, mu, sqrt(Omega)))
model <- set.to.class("mixedDiffusion", y0.fun = function(phi, t) 0.5,
  parameter = list(phi = phi, mu = mu, Omega = Omega, gamma2 = 0.1),
  b.fun = function(phi, t, x) phi*x, sT.fun = function(t, x) x)
t <- seq(0, 1, by = 0.01)
data <- simulate(model, t = t, plot.series = TRUE)
}

