% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/estimate.R
\docType{methods}
\name{estimate,Regression-method}
\alias{estimate,Regression-method}
\title{Estimation for regression model}
\usage{
\S4method{estimate}{Regression}(model.class, t, data, nMCMC, propSd,
  adapt = TRUE, proposal = c("normal", "lognormal"))
}
\arguments{
\item{model.class}{class of the regression model including all required information, see \code{\link{Regression-class}}}

\item{t}{vector of time points}

\item{data}{vector of observation variables}

\item{nMCMC}{length of Markov chain}

\item{propSd}{vector of proposal variances for \eqn{\phi}}

\item{adapt}{if TRUE (default), proposal variance is adapted}

\item{proposal}{proposal density: "normal" (default) or "lognormal" (for positive parameters)}
}
\description{
Bayesian estimation of the parameter of the regression model
  \eqn{y_i = f(\phi, t_i) + \epsilon_i, \epsilon_i\sim N(0,\gamma^2\widetilde{s}(t_i))}.
}
\examples{
t <- seq(0,1, by = 0.01)
model <- set.to.class("Regression", fun = function(phi, t) phi[1]*t + phi[2],
                   parameter = list(phi = c(1,2), gamma2 = 0.1))
data <- simulate(model, t = t, plot.series = TRUE)
est <- estimate(model, t, data, 1000)
plot(est)
}
\references{
Hermann, S., K. Ickstadt, and C. H. Mueller (2016).
Bayesian Prediction of Crack Growth Based on a Hierarchical Diffusion Model.
Applied Stochastic Models in Business and Industry, DOI: 10.1002/asmb.2175.
}

