% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/helpingFunctions.R
\name{diagnostic}
\alias{diagnostic}
\title{Calculation of a proposal for burn-in phase and thinning rate}
\usage{
diagnostic(chain, dependence = 0.8, m = 10)
}
\arguments{
\item{chain}{vector of Markov chain samples}

\item{dependence}{allowed dependence for the chain}

\item{m}{number of blocks}
}
\value{
vector of burn-in and thinning
}
\description{
The proposed burn-in is calculated by dividing the Markov chains into \code{m} blocks and calculate the 95\% credibility intervals and the respective mean.
Starting in the first one, the block is taken as burn-in as long as the mean of the current block is not in the credibility interval of the following block or vice versa.
The thinning rate is proposed by the first lag which leads to a chain autocorrelation less than \code{dependence}.
It is not easy to automate these choices, so it is highly recommended to verify the chains manually.
}

