\name{bgbb.PosteriorMeanTransactionRate}
\alias{bgbb.PosteriorMeanTransactionRate}
\alias{bgbb.rf.matrix.PosteriorMeanTransactionRate}
\title{BG/BB Posterior Mean Transaction Rate}
\usage{
  bgbb.PosteriorMeanTransactionRate(params, x, t.x, n.cal)

  bgbb.rf.matrix.PosteriorMeanTransactionRate(params,
    rf.matrix)
}
\arguments{
  \item{params}{BG/BB parameters - a vector with alpha,
  beta, gamma, and delta, in that order. Alpha and beta are
  unobserved parameters for the beta-Bernoulli transaction
  process. Gamma and delta are unobserved parameters for
  the beta-geometric dropout process.}

  \item{x}{number of repeat transactions a customer made in
  the calibration period, or a vector of calibration period
  transaction frequencies.}

  \item{t.x}{recency - the last transaction opportunity in
  which a customer made a transaction, or a vector of
  recencies.}

  \item{n.cal}{number of transaction opportunities in the
  calibration period, or a vector of calibration period
  transaction opportunities.}

  \item{rf.matrix}{recency-frequency matrix. It must
  contain columns for frequency ("x"), recency ("t.x"), and
  the number of transaction opportunities in the
  calibration period ("n.cal"). Note that recency must be
  the time between the start of the calibration period and
  the customer's last transaction, not the time between the
  customer's last transaction and the end of the
  calibration period.}
}
\value{
  The posterior mean transaction rate.
}
\description{
  Computes the mean value of the marginal posterior value
  of P, the Bernoulli transaction process parameter.
}
\details{
  E(P | alpha, beta, gamma, delta, x, t.x, n). This is
  calculated by setting l=1 and m=0 in
  \code{\link{bgbb.PosteriorMeanLmProductMoment}}.

  \code{x}, \code{t.x}, and \code{n.cal} may be vectors.
  The standard rules for vector operations apply - if they
  are not of the same length, shorter vectors will be
  recycled (start over at the first element) until they are
  as long as the longest vector. It is advisable to keep
  vectors to the same length and to use single values for
  parameters that are to be the same for all calculations.
  If one of these parameters has a length greater than one,
  the output will be also be a vector.
}
\examples{
data(donationsSummary)

rf.matrix <- donationsSummary$rf.matrix
# donationsSummary$rf.matrix already has appropriate column names

# starting-point parameters
startingparams <- c(1, 1, 0.5, 3)
# estimated parameters
est.params <- bgbb.EstimateParameters(rf.matrix, startingparams)

# return the posterior mean transaction rate vector
bgbb.rf.matrix.PosteriorMeanTransactionRate(est.params, rf.matrix)
}
\references{
  Fader, Peter S., Bruce G.S. Hardie, and Jen Shang.
  \dQuote{Customer-Base Analysis in a Discrete-Time
  Noncontractual Setting.} \emph{Marketing Science} 29(6),
  pp. 1086-1108. 2010. INFORMS.
  \url{http://www.brucehardie.com/papers/020/}
}

