% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimplePetersen.R
\name{SimplePetersen}
\alias{SimplePetersen}
\alias{TestIfPool}
\title{Simple Petersen Estimator and test if pooling can be done}
\usage{
SimplePetersen(n1, m2, u2)
}
\arguments{
\item{n1}{Number of animals tagged and released. Can be a vector in which the estimate is formed for each element of the vector}

\item{m2}{Number of animals from n1 that are recaptured.}

\item{u2}{Number of unmarked animals in the second sample.}
}
\value{
Data frame with variables U.est, U.se, N.est, and N.se.
.
}
\description{
Computes the Petersen estimator (Chapman correction applied) for the number of UNMARKED animals (U)
and total population (N) given n1, m2, and u2.
}
\examples{
 
SimplePetersen( 200, 10, 300) 
SimplePetersen(c(200,400), c(10,20), c(300,600))


}
\author{
Bonner, S.J. \email{sbonner6@uwo.ca} and 
Schwarz, C. J. \email{cschwarz.stat.sfu.ca@gmail.com}.
}
