% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rand_model.R
\name{gen_one_rmodel}
\alias{gen_one_rmodel}
\title{Generate a random Boolean model}
\usage{
gen_one_rmodel(var, exponent = 3, and_bool, self_loop = F,
  mvar = length(var), model_type = "random")
}
\arguments{
\item{var}{character vector. A vector of single genes/variables to be used in the model.}

\item{exponent}{integer. The exponent of power law distribution. Default to 3.}

\item{and_bool}{logical. Indicates whether to include AND terms or not.}

\item{self_loop}{logical. Indicates whether to allow self_loop. Default to F.}

\item{mvar}{integer. Maximum number of variables in act or inh rule. Default to length(var).}

\item{model_type}{character. Specifies the type of model generated.}
}
\description{
This function generates a random Boolean model. Returns an S4 BoolModel object.
Note that this method will not give empty rule, i.e. 0 term in both act and inh rules.
}
\details{
The number of terms in a function for a gene is modelled by power-law distribution.
}

