% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Darwin}
\alias{Darwin}
\title{Charles Darwin's study of cross-fertilized and self-fertilized plants}
\format{
A data frame/tibble with 15 observations on three variables
\describe{ 
\item{pot}{number of pot} 
\item{cross}{height of plant (in inches) after a fixed period of time when cross-fertilized} 
\item{self}{height of plant (in inches) after a fixed period of time when self-fertilized}
}
}
\source{
Darwin, C. (1876) \emph{The Effect of Cross- and Self-Fertilization in the 
Vegetable Kingdom}, 2nd edition, London.
}
\usage{
Darwin
}
\description{
Data for Exercise 7.62
}
\examples{

differ <- Darwin$cross - Darwin$self
qqnorm(differ)
qqline(differ)
shapiro.test(differ)
wilcox.test(Darwin$cross, Darwin$self, paired = TRUE)
rm(differ)

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
