% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Censored}
\alias{Censored}
\title{Entry age and survival time of patients with small cell lung cancer under
two different treatments}
\format{
A data frame/tibble  with 121 observations on three variables
\describe{ 
\item{survival}{survival time (in days) of patients with small cell lung cancer} 
\item{treatment}{a factor with levels \code{armA} and \code{armB} indicating the 
treatment a patient received} 
\item{age}{the age of the patient} 
}
}
\source{
Ying, Z., Jung, S., Wei, L. 1995. \dQuote{Survival Analysis with Median Regression Models.} 
\emph{Journal of the American Statistical Association}, 90, 178-184.
}
\usage{
Censored
}
\description{
Data for Exercises 7.34 and 7.48
}
\examples{

boxplot(survival ~ treatment, data = Censored, col = "yellow")
wilcox.test(survival ~ treatment, data = Censored, alternative = "greater")

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
