% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_sim_exp_nocovar.R
\name{run_sim_exp_nocovar}
\alias{run_sim_exp_nocovar}
\title{Run simulation of two-arm trials with an exponentially distributed time-to-event endpoint and no predictor of the intercurrent event}
\usage{
run_sim_exp_nocovar(n_iter, d_params, m_params, seed)
}
\arguments{
\item{n_iter}{Positive integer value, number of trials to be simulated.}

\item{d_params}{List of data parameters as used in \code{sim_dat_one_trial_exp_nocovar}.}

\item{m_params}{List of model parameters as used in \code{fit_single_exp_nocovar}.}

\item{seed}{Numeric value, seed for reproducibility.}
}
\value{
A list of length 3, containing objects call \code{ocs}, \code{d_params}, \code{m_params}, where \code{ocs} is a \code{tibble} containing averaged parameter estimates and operating characteristics, and \code{d_params} and \code{m_params} are the objects supplied to the function.
}
\description{
Run simulation of two-arm trials with an exponentially distributed time-to-event endpoint and no predictor of the intercurrent event
}
\examples{
d_params_nocovar <- list(
  n = 500L,
  nt = 250L,
  prob_ice = 0.5,
  fu_max = 336L,
  T0T_rate = 0.2,
  T0N_rate = 0.2,
  T1T_rate = 0.15,
  T1N_rate = 0.1
)
m_params_nocovar <- list(
  tg = 48L,
  prior_piT = c(0.5, 0.5),
  prior_0N = c(1.5, 5),
  prior_1N = c(1.5, 5),
  prior_0T = c(1.5, 5),
  prior_1T = c(1.5, 5),
  t_grid =  seq(7, 7 * 48, 7) / 30,
  chains = 2L,
  n_iter = 3000L,
  warmup = 1500L,
  cores = 2L,
  open_progress = FALSE,
  show_messages = TRUE  
)
\donttest{ 
dat_ocs <- run_sim_exp_nocovar(
  n_iter = 3, 
  d_params = d_params_nocovar, 
  m_params = m_params_nocovar, 
  seed = 12
  )
print(dat_ocs)
}
}
\seealso{
\code{\link[=run_sim_exp_covar]{run_sim_exp_covar()}}
}
