% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BMTME.R, R/BMTME_Package.R
\docType{package}
\name{BMTME}
\alias{BMTME}
\alias{BMTME-package}
\title{Bayes Multi-Trait Milti-Environment Model (BMTME)}
\usage{
BMTME(Y, X, Z1, Z2, nIter = 1000L, burnIn = 300L, thin = 2L,
  bs = ceiling(dim(Z1)[2]/6), parallelCores = 1, digits = 4,
  progressBar = TRUE, testingSet = NULL)
}
\arguments{
\item{Y}{\code{(matrix)} Phenotypic response where each column is a different trait.}

\item{X}{\code{(matrix)} Matrix design for the environment effects.}

\item{Z1}{\code{(matrix)} Matrix design for the genetic effects.}

\item{Z2}{\code{(matrix)} Matrix design for the genetic effects interaction with the environment effects.}

\item{nIter}{\code{(integer)} Number of iterations to fit the model.}

\item{burnIn}{\code{(integer)} Number of items to burn at the beginning of the model.}

\item{thin}{\code{(integer)} Number of items to thin the model.}

\item{bs}{\code{(integer)} Number of groups.}

\item{parallelCores}{\code{(integer)} Number of cores to use.}

\item{digits}{\code{(integer)} Number of digits of accuracy in the results.}

\item{progressBar}{\code{(Logical)} Show the progress bar.}

\item{testingSet}{\code{(object or vector)} Crossvalidation object or vector with the positions to use like testing in a cross-validation test.}
}
\description{
The Bayesian Multi-Trait Multi-Environment models (BMTME) package was developed to implement...
}
\examples{
\donttest{
  data("WheatIranianToy")

  # Matrix Design
  LG <- cholesky(genoIranianToy)
  ZG <- model.matrix(~0 + as.factor(phenoIranianToy$GID))
  Z.G <- ZG \%*\% LG
  Z.E <- model.matrix(~0 + as.factor(phenoIranianToy$Env))
  ZEG <- model.matrix(~0 + as.factor(phenoIranianToy$GID):as.factor(phenoIranianToy$Env))
  G2 <- kronecker(diag(length(unique(phenoIranianToy$Env))), data.matrix(genoIranianToy))
  LG2 <- cholesky(G2)
  Z.EG <- ZEG \%*\% LG2

  #Pheno
  Y <- as.matrix(phenoIranianToy[, -c(1, 2)])

  #Check fitting
  fm <- BMTME(Y = Y, X = Z.E, Z1 = Z.G, Z2 = Z.EG,
              nIter = 10000, burnIn = 5000, thin = 2, bs = 50)
  fm

  # Check predictive capacities of the model
  pheno <- data.frame(GID = phenoIranianToy[, 1],
                      Env = phenoIranianToy[, 2],
                      Response = phenoIranianToy[, 3])
  CrossV <- CV.RandomPart(pheno, NPartitions = 4, PTesting = 0.2, set_seed = 123)

  pm <- BMTME(Y = Y, X = Z.E, Z1 = Z.G, Z2 = Z.EG,
              nIter = 10000, burnIn = 5000, thin = 2,
              bs = 50, testingSet = CrossV)
  pm
}

}
\references{
Montesinos-Lopez, O.A., Montesinos-Lopez, A., Crossa, J., Toledo, F.H., Perez-Hernandez, O., Eskridge, K.M., … Rutkoski, J. (2016).
A Genomic Bayesian Multi-trait and Multi-environment Model. G3: Genes|Genomes|Genetics, 6(9), 2725–2744. \url{https://doi.org/10.1534/g3.116.032359}.
}
